#
# stripeverything()
# Goes through the package tree and strips all ELF stuff (binaries,
# libraries, and so on).
#
# Parameters:   $1    The package tree.
#

stripeverything() {
   cd $1

   # strip shared libraries and binaries
   if [ ! "$STRIPLIB" = "" -o ! "$STRIPBIN" = "" ]
   then
      msgOut=n

      for testname in `find . -type f`
      do
         islib="`file $testname | grep ELF | \
                                  grep 'shared object' | \
                                  grep 'not stripped'`"
         isprog="`file $testname | grep ELF | \
                                   grep executable | \
                                   grep 'not stripped'`"

         # strip binaries if the user so desires
         if [ ! "$isprog" = "" -a "$STRIPBIN" = "y" ]
         then
            if [ "$msgOut" = "n" ]
            then
               echo
               echo "Stripping programs and libraries..."
               msgOut=y
            fi

            echo "   --> $testname"
            strip -p $testname 2>/dev/null 1>/dev/null
         fi

         # strip libraries if the user so desires
         if [ ! "$islib" = "" -a "$STRIPLIB" = "y" ]
         then
            if [ "$msgOut" = "n" ]
            then
               echo 
               echo "Stripping programs and libraries..."
               msgOut=y
            fi

            echo "   --> $testname"
            strip -p $testname 2>/dev/null 1>/dev/null
         fi 
      done

      if [ "$msgOut" = "y" ]
      then
         echo
      fi
   fi

   # ranlib static libraries
   msgOut=n
   for libname in `find . -name *.a -type f`
   do
      if [ ! "`file $libname | grep 'current ar archive'`" = "" ]
      then
         if [ "$msgOut" = "n" ]
         then
            echo 
            echo "Generating static library indexes..."
            msgOut=y
         fi

         echo "   --> $libname"
         ranlib $libname 2>/dev/null 1>/dev/null
      fi
   done
}
