#
# permissionize()
# Called by protopkg() to fix permissions on the temporary package build
# directory.  It sets all bin and sbin stuff to root.bin, chmod'ed 755.
# After that it runs the ownerships and permissions functions from the
# package prototype file (to set any special permissions the package
# maintainer wants).
#
# Parameters:   $1    The package tree.
#

permissionize() {
   cd $1

   if [ ! "$SETATTR" = "n" ]
   then
      # default system-wide permissions
      find . -exec chown root.root {} \; 1>/dev/null 2>/dev/null
      find . -type d -exec chmod 755 {} \; 1>/dev/null 2>/dev/null
      find . -type d -exec chown root.root {} \; 1>/dev/null 2>/dev/null

      # default bin and sbin permissions (root.bin, 755)
      for d in usr/bin usr/sbin usr/X11R6/bin bin sbin usr/local/bin usr/local/sbin
      do
         chown -R root.bin $1/$d 2>/dev/null
         chmod -R 755 $1/$d 2>/dev/null
      done

      # default include permissions
      find usr/include -name *.h -exec chmod 644 {} \; 1>/dev/null 2>/dev/null
      find usr/X11R6/include -name *.h -exec chmod 644 {} \; 1>/dev/null 2>/dev/null

      # default man and info page permissions
      find usr/man -type f -exec chmod 644 {} \; 1>/dev/null 2>/dev/null
      find usr/X11R6/man -type f -exec chmod 644 {} \; 1>/dev/null 2>/dev/null
      find usr/info -type f -exec chmod 644 {} \; 1>/dev/null 2>/dev/null

      # default /usr/doc permissions and ownerships
      find . | grep "usr/doc" | xargs chown root.root 1>/dev/null 2>/dev/null
      find . -type f | grep "usr/doc" | xargs chmod 644 1>/dev/null 2>/dev/null
      find . -type d | grep "usr/doc" | xargs chmod 755 1>/dev/null 2>/dev/null
   fi

   # run the user-defined functions
   if [ ! "$SUBPKGNAME" = "" ]
   then
      ### we're in a subpackage, a la repack()
      subattributes 2>/dev/null 1>/dev/null
   else
      ### looks like a regular ol' package to me
      attributes 2>/dev/null 1>/dev/null
   fi
}
