<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_authn_core - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_authn_core</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authn_core.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authn_core.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Le noyau de l'authentification</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>authn_core_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_authn_core.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3 d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module fournit le coeur des fonctionnalits d'authentification
    permettant d'accorder ou de refuser l'accs  certaines zones du
    site web. Les directives fournies par le module
    <code class="module"><a href="../mod/mod_authn_core.html">mod_authn_core</a></code> sont communes  tous les
    fournisseurs d'authentification.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#authname">AuthName</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authnprovideralias">&lt;AuthnProviderAlias&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authtype">AuthType</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#authnalias">Cration d'alias de fournisseurs
d'authentification</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="authnalias" id="authnalias">Cration d'alias de fournisseurs
d'authentification</a></h2>

    <p>Il est possible de crer des fournisseurs d'authentification
    tendus dans le fichier de configuration et de leur assigner un
    alias. Le fournisseur ainsi nomm peut alors tre rfrenc  l'aide
    des directives <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code> ou <code class="directive"><a href="../mod/mod_auth_digest.html#authdigestprovider">AuthDigestProvider</a></code> tout comme
    un fournisseur d'authentification de base. Outre la possibilit de
    crer et attribuer un alias  un fournisseur tendu, le mme
    fournisseur d'authentification peut aussi tre rfrenc par
    plusieurs sections relatives  une zone du site web.</p>

    <h3><a name="example" id="example">Exemples</a></h3>

	<p>Cet exemple vrifie les mots de passe dans deux fichiers
	textes diffrents.</p>

	<div class="example"><h3>Vrification dans plusieurs fichiers de mots de
	passe au format texte</h3><pre class="prettyprint lang-config">
# Premire vrification
&lt;AuthnProviderAlias file file1&gt;
    AuthUserFile /www/conf/passwords1
&lt;/AuthnProviderAlias&gt;

# Vrification suivante
&lt;AuthnProviderAlias file file2&gt;   
    AuthUserFile /www/conf/passwords2
&lt;/AuthnProviderAlias&gt;

&lt;Directory /var/web/pages/secure&gt;
    AuthBasicProvider file1 file2
    
    AuthType Basic
    AuthName "Protected Area"
    Require valid-user
&lt;/Directory&gt;
        </pre>
</div>



        <p>Dans l'exemple ci-dessous, deux fournisseurs
	d'authentification ldap sont crs  partir du fournisseur ldap
	de base, et se voient attribuer un alias. L'authentification
	d'une mme zone peut alors tre traite par plusieurs serveurs
	ldap :</p>

        <div class="example"><h3>Vrification auprs de plusieurs serveurs
	LDAP</h3><pre class="prettyprint lang-config">
&lt;AuthnProviderAlias ldap ldap-alias1&gt;
    AuthLDAPBindDN cn=youruser,o=ctx
    AuthLDAPBindPassword yourpassword
    AuthLDAPURL ldap://ldap.host/o=ctx
    &lt;/AuthnProviderAlias&gt;
    &lt;AuthnProviderAlias ldap ldap-other-alias&gt;
    AuthLDAPBindDN cn=yourotheruser,o=dev
    AuthLDAPBindPassword yourotherpassword
    AuthLDAPURL ldap://other.ldap.host/o=dev?cn
&lt;/AuthnProviderAlias&gt;

Alias /secure /webpages/secure
&lt;Directory /webpages/secure&gt;
    Order deny,allow
    Allow from all
    
    AuthBasicProvider ldap-other-alias  ldap-alias1
    
    AuthType Basic
    AuthName LDAP_Protected Place
    Require valid-user
    # Notez que Require ldap-* ne fonctionnerait pas ici, car
    # AuthnProviderAlias ne fournit pas de configuration pour les
    # fournisseurs d'autorisation implments dans le mme module que le
    # fournisseur d'authentification.
&lt;/Directory&gt;
          </pre>
</div>
    

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthName" id="AuthName">AuthName</a> <a name="authname" id="authname">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>L'identifiant de l'autorisation  utiliser avec
l'authentification HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthName <var>domaine d'autorisation</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authn_core</td></tr>
</table>
    <p>Cette directive permet de dfinir l'identifiant d'autorisation
    pour un rpertoire. Cet identifiant est fourni au client de faon 
    ce qu'il sache quels nom d'utilisateur et mot de passe envoyer.
    <code class="directive">AuthName</code> accepte un seul argument ; s'il
    contient des espaces, il doit tre entour de guillemets. Pour
    pouvoir fonctionner, la directive <code class="directive">AuthName</code>
    doit tre utilise en combinaison avec les directives <code class="directive"><a href="#authtype">AuthType</a></code> et <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>, ainsi que des
    directives comme <code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code> et <code class="directive"><a href="../mod/mod_authz_groupfile.html#authgroupfile">AuthGroupFile</a></code>.</p>

   <p>Par exemple :</p>

   <pre class="prettyprint lang-config">
     AuthName "Top Secret"
   </pre>


    <p>La chane fournie comme argument  <code>AuthName</code>
    apparatra dans la bote de dialogue d'authentification pour la
    plupart des navigateurs.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../howto/auth.html">Authentification, autorisation et contrle
    d'accs</a></li>
<li><code class="module"><a href="../mod/mod_authz_core.html">mod_authz_core</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthnProviderAlias" id="AuthnProviderAlias">&lt;AuthnProviderAlias&gt;</a> <a name="authnprovideralias" id="authnprovideralias">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Regroupe un ensemble de directives qui constituent une
extension d'un fournisseur d'authentification de base et lui attribue
l'alias spcifi</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;AuthnProviderAlias <var>alias-fournisseur</var>&gt;
... &lt;/AuthnProviderAlias&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authn_core</td></tr>
</table>
    <p>Les balises <code>&lt;AuthnProviderAlias&gt;</code> et
    <code>&lt;/AuthnProviderAlias&gt;</code> permettent de regrouper un
    ensemble de directives d'authentification qui seront rfrences par
    l'alias spcifi  l'aide des directives <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code> ou <code class="directive"><a href="../mod/mod_auth_digest.html#authdigestprovider">AuthDigestProvider</a></code>.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AuthType" id="AuthType">AuthType</a> <a name="authtype" id="authtype">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Type d'authentification utilisateur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthType None|Basic|Digest|Form</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authn_core</td></tr>
</table>
    <p>Cette directive permet de dfinir le type d'authentification
    utilisateur pour un rpertoire. Les types d'authentification
    disponibles sont <code>None</code>, <code>Basic</code> (implment
    par <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code>), <code>Digest</code>
    (implment par <code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code>), et
    <code>Form</code> (implment par
    <code class="module"><a href="../mod/mod_auth_form.html">mod_auth_form</a></code>).</p>

    <p>Pour mettre en oeuvre l'authentification, vous devez aussi
    utiliser les directives <code class="directive"><a href="#authname">AuthName</a></code> et <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>. De plus, le serveur
    doit pouvoir disposer d'un module fournisseur d'authentification
    comme <code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code> et d'un module d'autorisation
    comme <code class="module"><a href="../mod/mod_authz_user.html">mod_authz_user</a></code>.</p>

    <p>Le type d'authentification <code>None</code> dsactive
    l'authentification. Lorsqu'une authentification est dfinie, elle
    est en gnral hrite par chacune des <a href="../sections.html#mergin">sections de configuration</a> qui
    suivent,  moins qu'un autre type d'authentification ne soit
    spcifi. Si l'on ne souhaite pas mettre en oeuvre
    d'authentification pour une sous-section d'une section authentifie,
    on doit utiliser le type d'authentification <code>None</code> ; dans
    l'exemple suivant, les clients peuvent accder au rpertoire
    <code>/www/docs/public</code> sans devoir s'authentifier :</p>

    <pre class="prettyprint lang-config">
&lt;Directory /www/docs&gt;
    AuthType Basic
    AuthName Documents
    AuthBasicProvider file
    AuthUserFile /usr/local/apache/passwd/passwords
    Require valid-user
&lt;/Directory&gt;

&lt;Directory /www/docs/public&gt;
    AuthType None
    Require all granted
&lt;/Directory&gt;
    </pre>


    <div class="note">Veuillez noter que, lorsque l'authentification n'est pas
    active, les clients qui se sont dj authentifis pour une autre
    zone de l'arborescence du site continueront en gnral  envoyer des
    en-tte d'authentification HTTP ou des cookies avec chaque requte,
    sans se proccuper de savoir si le serveur ncessite vraiment une
    authentification pour chaque ressource.</div>

<h3>Voir aussi</h3>
<ul>
<li><a href="../howto/auth.html">Authentification, autorisation et contrle
    d'accs</a></li>
</ul>
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authn_core.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authn_core.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_authn_core.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2012 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>