.\" Copyright 2004 Red Hat Inc., Durham, North Carolina.
.\" All Rights Reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation on the rights to use, copy, modify, merge,
.\" publish, distribute, sublicense, and/or sell copies of the Software,
.\" and to permit persons to whom the Software is furnished to do so,
.\" subject to the following conditions:
.\"
.\" he above copyright notice and this permission notice (including the
.\" next paragraph) shall be included in all copies or substantial
.\" portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
.\" NON-INFRINGEMENT.  IN NO EVENT SHALL RED HAT AND/OR THEIR SUPPLIERS
.\" BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
.\" ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.TH DMXGetInputAttributes __libmansuffix__ __vendorversion__
.SH NAME
DMXGetInputAttributes \- determine input device attributes
.SH SYNOPSIS
.B #include <X11/extensions/dmxext.h>
.sp
.nf
.BI "Bool DMXGetInputAttributes(Display " *dpy ,
.BI "                           int " id ,
.BI "                           DMXInputAttributes " *attr );
.fi
.SH DESCRIPTION
.B DMXGetInputAttributes()
returns information about the input device specified with
.IR id .
This information cannot be
obtained from the
.BR XListInputDeivices (__libmansuffix__)
call.
.I id
is the same as that used by the
.BR XListInputDevices (__libmansuffix__)
call, and must be in
the range 0 to one less than the value returned by
.BR DMXGetInputCount(__libmansuffix__) ,
inclusive.
.PP
The
.B DMXInputAttributes
structure is:
.sp
.nf
typedef struct {
    DMXInputEnum inputType;
    int          physicalScreen;
    int          physicalId;
    Bool         isCore;
    Bool         sendsCore;
    const char   *name;
    Bool         detached;
} DMXInputAttributes;
.fi
.PP
The value of
.I inputType
will always be valid, and will have one of the following values,
depending on the type of input:
.B DMXLocalInputType ", " DMXConsoleInputType ", or" DMXBackendInputType .
.PP
For local devices, all other fields returned, except
.I isCore " and " sendsCore ,
are invalid.
.PP
For console devices, 
.I physicalScreen " and " physicalID
will be invalid, and
.I name
will return the name of the X server on which the console window is
displayed.
.PP
For back-end devices,
.I physicalScreen
will identify the back-end display and can be used as an argument to
.BR DMXGetScreenAttributes (__libmansuffix__)
to obtain more information;
.I physicalId
will be the XInput device id on the back-end X server; and
.I name
will be invalid (since it does not provide any additional information
that cannot be obtained with
.BR DMXGetScreenAttributes (__libmansuffix__)).
.PP
If
.I isCore
is
.BR True ,
then this device is active as a true core input device and will send
core events.  If
.B sendsCore
is True, then this device is an XInput extension device, but sends core
events
.I instead
of extension events.  This behavior is different from that of XFree86 or
Xorg, where XInput extension devices may send
.I both
extension events and core events.
.PP
If
.I detached
is True, then this device has been detached and is no longer producing
input events.  The device may be reattached using
.BR DMXAddInput (__libmansuffix__).
.SH "RETURN VALUE"
.B DMXGetInputAttributes()
returns
.B True
unless there is a protocol error.
.PP
.B DMXGetInputAttributes()
can generate
.B BadValue
(if the value of
.I id
is out of range).
.SH "SEE ALSO"
.BR DMXGetInputCount "(__libmansuffix__), "
.BR XListInputDevices "(__libmansuffix__), "
.BR DMXGetScreenAttributes "(__libmansuffix__), "
.BR DMXAddInput "(__libmansuffix__), "
.BR DMX "(__libmansuffix__), " Xdmx (1)
