/*
 * Copyright (C) 2001-2003 the xine-project
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: utils.h,v 1.10 2003/03/20 19:03:09 guenter Exp $
 *
 * needful things
 */

#ifndef HAVE_UTILS_H
#define HAVE_UTILS_H 

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

void utils_init (void);

void ensure_path_exists (char *path) ;

char *read_entire_file (const char *mrl, int *file_size) ;

/* read an unicode text file and convert it to 0-terminated ascii */
char *read_entire_file_unicode (const char *mrl) ;
/* read an ascii text file and convert it to 0-terminated ascii */
char *read_entire_file_ascii (const char *mrl) ;


/* load an image from the system-wide gxine image dir */
GdkPixbuf *load_icon (const char *filename);

void display_error (gchar *title, gchar *fmt, ...) ;
void display_info (gchar *title, gchar *fmt, ...) ;

void int_to_timestring (gint int_time, char* string_time, gint length) ;
int parse_timestring (const char *string_time);

gchar *modal_file_dialog (const char *title, const char *pattern);
/* use g_strfreev() to freethe  return value of this one: */
gchar **modal_multi_file_dialog (const char *title, const char *pattern);

void normalize_to_ascii (char *str);

#endif
