
#include "packagelistjob.h"
#include "package.h"
#include "packageimpl.h"
#include "bugserver.h"
#include "domprocessor.h"

#include <kdebug.h>
#include <assert.h>

#include <qdom.h>

PackageListJob::PackageListJob( BugServer *server )
  : XmlBugJob( server )
{
}

PackageListJob::~PackageListJob()
{
}

void PackageListJob::start()
{
    XmlBugJob::start( server()->packageListUrl() );
}

void PackageListJob::process( const QByteArray &data )
{
    QDomDocument doc;
    if ( !doc.setContent( data ) ) {
      kdDebug() << "Error parsing xml response for package list request."
                << endl;
      return;
    }
    
    QDomElement bugzilla = doc.documentElement();

    if ( bugzilla.isNull() ) {
      kdDebug() << "No document in xml response." << endl;
      return;
    }

    Package::List packages = dom()->parsePackageList( bugzilla );

    emit packageListAvailable( packages );
}

#include "packagelistjob.moc"

/* 
 * vim:sw=4:ts=4:et
 */
