/***************************************************************************
                            SlaveInterface.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef SLAVEINTERFACE_H
#define SLAVEINTERFACE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 There are two classes that specifies the protocol between application (job)
 and kioslave. SlaveInterface is the class to use on the application end,
 SlaveBase is the one to use on the slave end.

 A call to -foo results in a call to -slotFoo on the other end.
 
 @short 
 There are two classes that specifies the protocol between application (job)
 and kioslave.
*/
@class Connection;

@interface Slave : QObject
- initWithConnection: (Connection*)connection;
- (void) dealloc;
- setConnection: (Connection*)connection;
- (Connection*) connection;
- setProgressId: (int)identifier;
- (int) progressId;
- sendResumeAnswer: (BOOL)resume;
- (BOOL) dispatch;
//- (BOOL) dispatch: (int)_cmd data: (QByteArray*)data;

/** 
 Prompt the user for authrization info (login & password).

 Use this function to request authorization info from the
 the end user. For example to open an empty password dialog
 using default values:

 <pre>
 -[KIO AuthInfo]authInfo;
 bool result = openPassDlg( authInfo );
 if ( result )
 {
    printf( "Username: %s", result.username.-latin1 );
    printf( "Username: %s", result.username.-latin1 );
 }
 </pre>

 You can also pre-set some values like the username before hand
 if it is known as well as the comment and caption to be displayed:

 <pre>
 authInfo.comment= "Enter username and password to access acmeone";
 authInfo.caption= "Acme Password Dialog";
 authInfo.username= "Wily E. kaiody";
 bool result = openPassDlg( authInfo );
 if ( result )
 {
    printf( "Username: %s", result.username.-latin1 );
    printf( "Username: %s", result.username.-latin1 );
 }
 </pre>

 NOTE: A call to this function can also fail and result
 in a return value of @p false, if the UIServer could not
 be started for whatever reason.

*/
//- openPassDlg: (AuthInfo*)info;

/** 
 Same as above except in the argument it accepts.

    
*/
- openPassDlg: (NSString *)prompt user: (NSString *)user caption: (NSString *)caption comment: (NSString *)comment label: (NSString *)label readOnly: (BOOL)readOnly;

/** 
 Same as above except in the argument it accepts.

    
*/
- openPassDlg: (NSString *)prompt user: (NSString *)user readOnly: (BOOL)readOnly;
- messageBox: (int)type text: (NSString *)text caption: (NSString *)caption buttonYes: (NSString *)buttonYes buttonNo: (NSString *)buttonNo;
- requestNetwork: (NSString *)arg1 string: (NSString *)arg2;
- dropNetwork: (NSString *)arg1 string: (NSString *)arg2;

/** 

     
*/
//+ sigpipe_handler: (int)arg1;
@end

/** Override these methods in subclasses of SlaveInterface to customise event handling behaviour */
@protocol SlaveEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
