/***************************************************************************
                            KFileTreeView.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The filetreeview offers a treeview on the file system which behaves like  
 a QTreeView showing files and/or directories in the file system.

 KFileTreeView is able to handle more than one URL, represented by
 {@link KFileTreeBranch}.

 Typical usage:
 1. create a KFileTreeView fitting in your layout and add columns to it
 2. call addBranch to create one or more branches
 3. retrieve the root item with {@link KFileTreeBranch#root} and set it open
    if desired. That starts the listing.
 
 See {@link KFileTreeViewSignals} for signals emitted by KFileTreeView.

 

 @short *
 The filetreeview offers a treeview on the file system which behaves like  
 a QTreeView showing files and/or directories in the file system.
*/
public class KFileTreeView extends KListView  {
	protected KFileTreeView(Class dummy){super((Class) null);}

	private native void newKFileTreeView( QWidget parent, String name);
	public KFileTreeView( QWidget parent, String name) {
		super((Class) null);
		newKFileTreeView( parent, name);
	}
	private native void newKFileTreeView( QWidget parent);
	public KFileTreeView( QWidget parent) {
		super((Class) null);
		newKFileTreeView( parent);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 

*/
	public native KFileTreeViewItem currentKFileTreeViewItem();

/** 

*/
	public native KURL currentURL();

/** 
  Adds a branch to the treeview item.

  This high-level function creates the branch, adds it to the treeview and
  connects some signals. Note that directory listing does not start until
  a branch is expanded either by opening the root item by user or by setOpen
  on the root item.

*/
	public native KFileTreeBranch addBranch( KURL path, String name, boolean showHidden);
	public native KFileTreeBranch addBranch( KURL path, String name);

/** 
  same as the function above but with a pixmap to set for the branch.
    
*/
	public native KFileTreeBranch addBranch( KURL path, String name, QPixmap pix, boolean showHidden);
	public native KFileTreeBranch addBranch( KURL path, String name, QPixmap pix);

/** 
  same as the function above but letting the user create the branch.
    
*/
	public native KFileTreeBranch addBranch( KFileTreeBranch arg1);

/** 
  removes the branch from the treeview.

*/
	public native boolean removeBranch( KFileTreeBranch branch);

/** 

*/
	public native KFileTreeBranch branch( String searchName);

/** 

*/
//	public native KFileTreeBranchList& branches();

/** 
  set the directory mode for branches. If true is passed, only directories will be loaded.

*/
	public native void setDirOnlyMode( KFileTreeBranch brnch, boolean arg1);

/** 
 searches a branch for a {@link KFileTreeViewItem} identified by the relative url given as
 second parameter. The method adds the branches base url to the relative path and finds
 the item.

*/
	public native KFileTreeViewItem findItem( KFileTreeBranch brnch, String relUrl);

/** 
 see method above, differs only in the first parameter. Finds the branch by its name.
    
*/
	public native KFileTreeViewItem findItem( String branchName, String relUrl);

/** 

*/
	public native boolean showFolderOpenPixmap();

/** 
 set the flag to show 'extended' folder icons on or off. If switched on, folders will
 have an open folder pixmap displayed if their children are visible, and the standard
 closed folder pixmap (from mimetype folder) if they are closed.
 If switched off, the plain mime pixmap is displayed.

*/
	public native void setShowFolderOpenPixmap( boolean showIt);
	public native void setShowFolderOpenPixmap();

/** 

*/
	protected native boolean acceptDrag( QDropEvent event);
	protected native QDragObject dragObject();
	protected native void startAnimation( KFileTreeViewItem item, String iconBaseName, int iconCount);
	protected native void startAnimation( KFileTreeViewItem item);
	protected native void stopAnimation( KFileTreeViewItem item);
	protected native void contentsDragEnterEvent( QDragEnterEvent e);
	protected native void contentsDragMoveEvent( QDragMoveEvent e);
	protected native void contentsDragLeaveEvent( QDragLeaveEvent e);
	protected native void contentsDropEvent( QDropEvent ev);
	protected native void virtual_hook( int identifier, int data);
//	protected native void slotNewTreeViewItems( KFileTreeBranch arg1, KFileTreeViewItemList* arg2);
	protected native void slotSetNextUrlToSelect( KURL url);
	protected native QPixmap itemIcon( KFileTreeViewItem arg1, int gap);
	protected native QPixmap itemIcon( KFileTreeViewItem arg1);
}
