/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.ThreadInfo;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageOutput {
    static ResourceBundle textResources;
    private static MessageFormat messageFormat;

    static void printPrompt() {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            System.out.print(MessageOutput.format("jdb prompt with no current thread"));
        } else {
            System.out.print(MessageOutput.format("jdb prompt thread name and current stack frame", new Object[]{threadInfo.getThread().name(), new Integer(threadInfo.getCurrentFrameIndex() + 1)}));
        }
        System.out.flush();
    }

    static void println() {
        System.out.println();
    }

    static void printDirect(char c) {
        System.out.print(c);
    }

    static void fatalError(String string) {
        System.err.println();
        System.err.println(MessageOutput.format("Fatal error"));
        System.err.println(MessageOutput.format(string));
        Env.shutdown();
    }

    static void lnprint(String string) {
        System.out.println();
        System.out.print(textResources.getString(string));
    }

    static void print(String string) {
        System.out.print(MessageOutput.format(string));
    }

    static void printDirect(String string) {
        System.out.print(string);
    }

    static void printDirectln(String string) {
        System.out.println(string);
    }

    static void println(String string) {
        System.out.println(MessageOutput.format(string));
    }

    static void printException(String string, Exception exception) {
        if (string != null) {
            try {
                MessageOutput.println(string);
            }
            catch (MissingResourceException missingResourceException) {
                MessageOutput.printDirectln(string);
            }
        }
        System.out.flush();
        exception.printStackTrace();
    }

    static void lnprint(String string, Object[] objectArray) {
        System.out.println();
        System.out.print(MessageOutput.format(string, objectArray));
    }

    static void println(String string, Object[] objectArray) {
        System.out.println(MessageOutput.format(string, objectArray));
    }

    static String format(String string) {
        return textResources.getString(string);
    }

    static void lnprint(String string, String string2) {
        System.out.println();
        System.out.print(MessageOutput.format(string, string2));
    }

    static void print(String string, String string2) {
        System.out.print(MessageOutput.format(string, string2));
    }

    static void println(String string, String string2) {
        System.out.println(MessageOutput.format(string, string2));
    }

    static synchronized String format(String string, Object[] objectArray) {
        if (messageFormat == null) {
            messageFormat = new MessageFormat(textResources.getString(string));
        } else {
            messageFormat.applyPattern(textResources.getString(string));
        }
        return messageFormat.format(objectArray);
    }

    static String format(String string, String string2) {
        return MessageOutput.format(string, new Object[]{string2});
    }
}

