/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl;

import com.sun.tools.corba.se.idl.Arguments;
import com.sun.tools.corba.se.idl.AttributeEntry;
import com.sun.tools.corba.se.idl.AttributeGen;
import com.sun.tools.corba.se.idl.ConstEntry;
import com.sun.tools.corba.se.idl.ConstGen;
import com.sun.tools.corba.se.idl.DefaultSymtabFactory;
import com.sun.tools.corba.se.idl.EnumEntry;
import com.sun.tools.corba.se.idl.EnumGen;
import com.sun.tools.corba.se.idl.ExceptionEntry;
import com.sun.tools.corba.se.idl.ExceptionGen;
import com.sun.tools.corba.se.idl.Factories;
import com.sun.tools.corba.se.idl.ForwardEntry;
import com.sun.tools.corba.se.idl.ForwardGen;
import com.sun.tools.corba.se.idl.ForwardValueEntry;
import com.sun.tools.corba.se.idl.ForwardValueGen;
import com.sun.tools.corba.se.idl.GenFactory;
import com.sun.tools.corba.se.idl.IncludeEntry;
import com.sun.tools.corba.se.idl.IncludeGen;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.InterfaceGen;
import com.sun.tools.corba.se.idl.InvalidArgument;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.MethodGen;
import com.sun.tools.corba.se.idl.ModuleEntry;
import com.sun.tools.corba.se.idl.ModuleGen;
import com.sun.tools.corba.se.idl.NativeEntry;
import com.sun.tools.corba.se.idl.NativeGen;
import com.sun.tools.corba.se.idl.NoPragma;
import com.sun.tools.corba.se.idl.Noop;
import com.sun.tools.corba.se.idl.ParameterEntry;
import com.sun.tools.corba.se.idl.ParameterGen;
import com.sun.tools.corba.se.idl.ParseException;
import com.sun.tools.corba.se.idl.Parser;
import com.sun.tools.corba.se.idl.PragmaEntry;
import com.sun.tools.corba.se.idl.PragmaGen;
import com.sun.tools.corba.se.idl.PragmaHandler;
import com.sun.tools.corba.se.idl.Preprocessor;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.PrimitiveGen;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.SequenceGen;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.StringGen;
import com.sun.tools.corba.se.idl.StructEntry;
import com.sun.tools.corba.se.idl.StructGen;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.SymtabFactory;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.TypedefGen;
import com.sun.tools.corba.se.idl.UnionEntry;
import com.sun.tools.corba.se.idl.UnionGen;
import com.sun.tools.corba.se.idl.Util;
import com.sun.tools.corba.se.idl.ValueBoxEntry;
import com.sun.tools.corba.se.idl.ValueBoxGen;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.ValueGen;
import com.sun.tools.corba.se.idl.constExpr.DefaultExprFactory;
import com.sun.tools.corba.se.idl.constExpr.ExprFactory;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class Compile {
    public Arguments arguments = null;
    protected Hashtable overrideNames = new Hashtable();
    protected Hashtable symbolTable = new Hashtable();
    protected Vector includes = new Vector();
    protected Vector includeEntries = new Vector();
    static Noop noop = new Noop();
    private GenFactory genFactory = null;
    private SymtabFactory symtabFactory = null;
    private ExprFactory exprFactory = null;
    private Parser parser = null;
    Preprocessor preprocessor = new Preprocessor();
    private NoPragma noPragma = new NoPragma();
    private Enumeration emitList = null;
    private String[] keywords = null;

    public Compile() {
        this.noPragma.init(this.preprocessor);
        this.preprocessor.registerPragma(this.noPragma);
        ParseException.detected = false;
        SymtabEntry.includeStack = new Stack();
        SymtabEntry.setEmit = true;
        Parser.repIDStack = new Stack();
    }

    protected void displayVersion() {
        String string = Util.getMessage("Version.product", Util.getMessage("Version.number"));
        System.out.println(string);
    }

    protected void generate() throws IOException {
        this.emitList = ParseException.detected ? null : this.parser.emitList.elements();
        if (this.emitList != null) {
            if (this.arguments.verbose) {
                System.out.println();
            }
            while (this.emitList.hasMoreElements()) {
                SymtabEntry symtabEntry = (SymtabEntry)this.emitList.nextElement();
                if (this.arguments.verbose && !(symtabEntry.generator() instanceof Noop)) {
                    if (symtabEntry.module().equals("")) {
                        System.out.println(Util.getMessage("Compile.generating", symtabEntry.name()));
                    } else {
                        System.out.println(Util.getMessage("Compile.generating", symtabEntry.module() + '/' + symtabEntry.name()));
                    }
                }
                symtabEntry.generate(this.symbolTable, null);
                if (!this.arguments.verbose || symtabEntry.generator() instanceof Noop) continue;
                if (symtabEntry.module().equals("")) {
                    System.out.println(Util.getMessage("Compile.genDone", symtabEntry.name()));
                    continue;
                }
                System.out.println(Util.getMessage("Compile.genDone", symtabEntry.module() + '/' + symtabEntry.name()));
            }
        }
    }

    private void initFactories() {
        Arguments arguments;
        Factories factories = this.factories();
        if (factories == null) {
            factories = new Factories();
        }
        this.arguments = (arguments = factories.arguments()) == null ? new Arguments() : arguments;
        SymtabFactory symtabFactory = factories.symtabFactory();
        this.symtabFactory = symtabFactory == null ? new DefaultSymtabFactory() : symtabFactory;
        ExprFactory exprFactory = factories.exprFactory();
        this.exprFactory = exprFactory == null ? new DefaultExprFactory() : exprFactory;
        GenFactory genFactory = factories.genFactory();
        this.genFactory = genFactory == null ? noop : genFactory;
        this.keywords = factories.languageKeywords();
        if (this.keywords == null) {
            this.keywords = new String[0];
        }
    }

    private void initGenerators() {
        AttributeGen attributeGen = this.genFactory.createAttributeGen();
        AttributeEntry.attributeGen = attributeGen == null ? noop : attributeGen;
        ConstGen constGen = this.genFactory.createConstGen();
        ConstEntry.constGen = constGen == null ? noop : constGen;
        EnumGen enumGen = this.genFactory.createEnumGen();
        EnumEntry.enumGen = enumGen == null ? noop : enumGen;
        ExceptionGen exceptionGen = this.genFactory.createExceptionGen();
        ExceptionEntry.exceptionGen = exceptionGen == null ? noop : exceptionGen;
        ForwardGen forwardGen = this.genFactory.createForwardGen();
        ForwardEntry.forwardGen = forwardGen == null ? noop : forwardGen;
        ForwardValueGen forwardValueGen = this.genFactory.createForwardValueGen();
        ForwardValueEntry.forwardValueGen = forwardValueGen == null ? noop : forwardValueGen;
        IncludeGen includeGen = this.genFactory.createIncludeGen();
        IncludeEntry.includeGen = includeGen == null ? noop : includeGen;
        InterfaceGen interfaceGen = this.genFactory.createInterfaceGen();
        InterfaceEntry.interfaceGen = interfaceGen == null ? noop : interfaceGen;
        ValueGen valueGen = this.genFactory.createValueGen();
        ValueEntry.valueGen = valueGen == null ? noop : valueGen;
        ValueBoxGen valueBoxGen = this.genFactory.createValueBoxGen();
        ValueBoxEntry.valueBoxGen = valueBoxGen == null ? noop : valueBoxGen;
        MethodGen methodGen = this.genFactory.createMethodGen();
        MethodEntry.methodGen = methodGen == null ? noop : methodGen;
        ModuleGen moduleGen = this.genFactory.createModuleGen();
        ModuleEntry.moduleGen = moduleGen == null ? noop : moduleGen;
        NativeGen nativeGen = this.genFactory.createNativeGen();
        NativeEntry.nativeGen = nativeGen == null ? noop : nativeGen;
        ParameterGen parameterGen = this.genFactory.createParameterGen();
        ParameterEntry.parameterGen = parameterGen == null ? noop : parameterGen;
        PragmaGen pragmaGen = this.genFactory.createPragmaGen();
        PragmaEntry.pragmaGen = pragmaGen == null ? noop : pragmaGen;
        PrimitiveGen primitiveGen = this.genFactory.createPrimitiveGen();
        PrimitiveEntry.primitiveGen = primitiveGen == null ? noop : primitiveGen;
        SequenceGen sequenceGen = this.genFactory.createSequenceGen();
        SequenceEntry.sequenceGen = sequenceGen == null ? noop : sequenceGen;
        StringGen stringGen = this.genFactory.createStringGen();
        StringEntry.stringGen = stringGen == null ? noop : stringGen;
        StructGen structGen = this.genFactory.createStructGen();
        StructEntry.structGen = structGen == null ? noop : structGen;
        TypedefGen typedefGen = this.genFactory.createTypedefGen();
        TypedefEntry.typedefGen = typedefGen == null ? noop : typedefGen;
        UnionGen unionGen = this.genFactory.createUnionGen();
        UnionEntry.unionGen = unionGen == null ? noop : unionGen;
    }

    protected Factories factories() {
        return new Factories();
    }

    protected void registerPragma(PragmaHandler pragmaHandler) {
        pragmaHandler.init(this.preprocessor);
        this.preprocessor.registerPragma(pragmaHandler);
    }

    protected void init(String[] stringArray) throws InvalidArgument {
        this.initFactories();
        this.arguments.parseArgs(stringArray);
        this.initGenerators();
        this.parser = new Parser(this.preprocessor, this.arguments, this.overrideNames, this.symbolTable, this.symtabFactory, this.exprFactory, this.keywords);
        this.preprocessor.init(this.parser);
        this.parser.includes = this.includes;
        this.parser.includeEntries = this.includeEntries;
    }

    public static void main(String[] stringArray) {
        new Compile().start(stringArray);
    }

    public void start(String[] stringArray) {
        try {
            this.init(stringArray);
            if (this.arguments.versionRequest) {
                this.displayVersion();
            } else {
                this.parse();
                this.generate();
            }
        }
        catch (InvalidArgument invalidArgument) {
            System.err.println(invalidArgument);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    protected Enumeration parse() throws IOException {
        if (this.arguments.verbose) {
            System.out.println(Util.getMessage("Compile.parsing", this.arguments.file));
        }
        this.parser.parse(this.arguments.file);
        if (!ParseException.detected) {
            this.parser.forwardEntryCheck();
        }
        if (this.arguments.verbose) {
            System.out.println(Util.getMessage("Compile.parseDone", this.arguments.file));
        }
        if (ParseException.detected) {
            this.symbolTable = null;
            this.emitList = null;
        } else {
            this.symbolTable = Parser.symbolTable;
            this.emitList = this.parser.emitList.elements();
        }
        return this.emitList;
    }
}

