/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.SmartSecurityDialog;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.PrintService;

public final class PrintServiceImpl
implements PrintService {
    private static PrintServiceImpl _sharedInstance = null;
    private PrinterJob _sysPrinterJob;
    private SmartSecurityDialog _securityDialog = new SmartSecurityDialog(Resources.getString("APIImpl.print.message"));
    private PageFormat _pageFormat = null;

    private PrintServiceImpl() {
        this._sysPrinterJob = PrinterJob.getPrinterJob();
    }

    private synchronized boolean askUser() {
        if (CheckServicePermission.hasPrintAccessPermissions()) {
            return true;
        }
        return this._securityDialog.showDialog();
    }

    public static synchronized PrintServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new PrintServiceImpl();
        }
        return _sharedInstance;
    }

    public PageFormat getDefaultPage() {
        if (this._sysPrinterJob != null) {
            return (PageFormat)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return PrintServiceImpl.this._sysPrinterJob.defaultPage();
                }
            });
        }
        return null;
    }

    public synchronized boolean print(Pageable pageable) {
        return this.doPrinting(null, pageable);
    }

    public synchronized boolean print(Printable printable) {
        return this.doPrinting(printable, null);
    }

    public PageFormat showPageFormatDialog(final PageFormat pageFormat) {
        if (this._sysPrinterJob != null) {
            return (PageFormat)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PrintServiceImpl.this._pageFormat = PrintServiceImpl.this._sysPrinterJob.pageDialog(pageFormat);
                    return PrintServiceImpl.this._pageFormat;
                }
            });
        }
        return null;
    }

    private boolean doPrinting(final Printable printable, final Pageable pageable) {
        if (!this.askUser()) {
            return false;
        }
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (pageable != null) {
                    PrintServiceImpl.this._sysPrinterJob.setPageable(pageable);
                } else if (PrintServiceImpl.this._pageFormat == null) {
                    PrintServiceImpl.this._sysPrinterJob.setPrintable(printable);
                } else {
                    PrintServiceImpl.this._sysPrinterJob.setPrintable(printable, PrintServiceImpl.this._pageFormat);
                }
                if (PrintServiceImpl.this._sysPrinterJob.printDialog()) {
                    Thread thread = new Thread(new Runnable(this){
                        private final /* synthetic */ 3 this$1;

                        public void run() {
                            try {
                                PrintServiceImpl.access$000(3.access$200(this.this$1)).print();
                            }
                            catch (PrinterException printerException) {
                                Debug.ignoredException(printerException);
                            }
                        }
                        {
                            this.this$1 = var1_1;
                        }
                    });
                    thread.start();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            static /* synthetic */ PrintServiceImpl access$200(3 var0) {
                return var0.PrintServiceImpl.this;
            }
        });
        return bl;
    }
}

