/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import sun.awt.dnd.SunDragSourceContextPeer;

class SynthDragGestureRecognizer
implements MouseListener,
MouseMotionListener {
    private MouseEvent dndArmedEvent = null;
    private static int motionThreshold;
    private static boolean checkedMotionThreshold;

    private static int getMotionThreshold() {
        if (checkedMotionThreshold) {
            return motionThreshold;
        }
        checkedMotionThreshold = true;
        try {
            motionThreshold = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
        }
        catch (Exception exception) {
            motionThreshold = 5;
        }
        return motionThreshold;
    }

    static {
        checkedMotionThreshold = false;
    }

    SynthDragGestureRecognizer() {
    }

    protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiersEx();
        if ((n2 & 0x400) != 1024) {
            return 0;
        }
        JComponent jComponent = this.getComponent(mouseEvent);
        TransferHandler transferHandler = jComponent.getTransferHandler();
        return SunDragSourceContextPeer.convertModifiersToDropAction(n2, transferHandler.getSourceActions(jComponent));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dndArmedEvent != null) {
            mouseEvent.consume();
            int n2 = this.mapDragOperationFromModifiers(mouseEvent);
            if (n2 == 0) {
                return;
            }
            int n3 = Math.abs(mouseEvent.getX() - this.dndArmedEvent.getX());
            int n4 = Math.abs(mouseEvent.getY() - this.dndArmedEvent.getY());
            if (n3 > SynthDragGestureRecognizer.getMotionThreshold() || n4 > SynthDragGestureRecognizer.getMotionThreshold()) {
                JComponent jComponent = this.getComponent(mouseEvent);
                TransferHandler transferHandler = jComponent.getTransferHandler();
                transferHandler.exportAsDrag(jComponent, this.dndArmedEvent, n2);
                this.dndArmedEvent = null;
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dndArmedEvent = null;
        if (this.isDragPossible(mouseEvent) && this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            this.dndArmedEvent = mouseEvent;
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dndArmedEvent = null;
    }

    protected boolean isDragPossible(MouseEvent mouseEvent) {
        JComponent jComponent = this.getComponent(mouseEvent);
        return jComponent == null ? true : jComponent.getTransferHandler() != null;
    }

    protected JComponent getComponent(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            return jComponent;
        }
        return null;
    }

    private TransferHandler getTransferHandler(MouseEvent mouseEvent) {
        JComponent jComponent = this.getComponent(mouseEvent);
        return jComponent == null ? null : jComponent.getTransferHandler();
    }
}

