#ifndef _FFT_H
#define _FFT_H

#ifdef HAVE_DFFTW_H
 #include <dfftw.h>
#endif
#ifdef HAVE_FFTW_H
 #include <fftw.h>
#endif

#define	FFT_FWD	FFTW_FORWARD
#define	FFT_REV	FFTW_BACKWARD

#include "cmplx.h"

struct fft {
	fftw_plan plan;
};

extern struct fft *fft_init(int len, int dir);

extern void fft_free(struct fft *s);

extern void fft_run(struct fft *s, complex *in, complex *out);

#endif
