/* ANSI-C code produced by gperf version 2.7.2 */
/* Command-line: gperf -a -L ANSI-C -E -C -c -o -t -k '*' -NfindEntity -Hhash_Entity -Wwordlist_Entity -D -s 2 kentities.gperf  */
/*   This file is part of the KDE libraries
  
     Copyright (C) 1999 Lars Knoll (knoll@mpi-hd.mpg.de)
  
     This library is free software; you can redistribute it and/or
     modify it under the terms of the GNU Library General Public
     License as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later version.
  
     This library is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Library General Public License for more details.
  
     You should have received a copy of the GNU Library General Public License
     along with this library; see the file COPYING.LIB.  If not, write to
     the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
  
  ----------------------------------------------------------------------------
  
    kentities.gperf: input file to generate a hash table for entities
    kentities.c: DO NOT EDIT! generated by the command
    "gperf -a -L "ANSI-C" -C -G -c -o -t -k '*' -NfindEntity -D -s 2 khtmlentities.gperf > entities.c"   
    from kentities.gperf 

    $Id: kentities.c,v 1.9 2002/04/15 20:53:43 lunakl Exp $     
*/  
struct entity {
    const char *name;
    int code;
};
/* maximum key range = 1870, duplicates = 1 */

#ifdef __GNUC__
__inline
#else
#ifdef __cplusplus
inline
#endif
#endif
static unsigned int
hash_Entity (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,    0,
        10,   15,    0, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874,  455,    0,   40,  140,  165,
      1874,    5,    5,  190, 1874,    5,   10,    0,   85,  230,
         0,   10,   20,   75,   15,  175, 1874, 1874,   20,   30,
        30, 1874, 1874, 1874, 1874, 1874, 1874,    0,  285,    5,
       110,   25,   55,  175,  280,   10,    0,    0,   30,  120,
       205,   40,  135,  275,    0,  590,  365,    5,  105,    5,
         5,  120,   45, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874, 1874,
      1874, 1874, 1874, 1874, 1874, 1874
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 8:
        hval += asso_values[(unsigned char)str[7]];
      case 7:
        hval += asso_values[(unsigned char)str[6]];
      case 6:
        hval += asso_values[(unsigned char)str[5]];
      case 5:
        hval += asso_values[(unsigned char)str[4]];
      case 4:
        hval += asso_values[(unsigned char)str[3]];
      case 3:
        hval += asso_values[(unsigned char)str[2]];
      case 2:
        hval += asso_values[(unsigned char)str[1]];
      case 1:
        hval += asso_values[(unsigned char)str[0]];
        break;
    }
  return hval;
}

#ifdef __GNUC__
__inline
#endif
const struct entity *
findEntity (register const char *str, register unsigned int len)
{
  enum
    {
      TOTAL_KEYWORDS = 274,
      MIN_WORD_LENGTH = 2,
      MAX_WORD_LENGTH = 8,
      MIN_HASH_VALUE = 4,
      MAX_HASH_VALUE = 1873
    };

  static const struct entity wordlist_Entity[] =
    {
      {"rarr", 0x2192},
      {"Mu", 0x039c},
      {"uarr", 0x2191},
      {"crarr", 0x21b5},
      {"Pi", 0x03a0},
      {"xi", 0x03be},
      {"GT", 62},
      {"Tau", 0x03a4},
      {"circ", 0x02c6},
      {"acirc", 0x00e2},
      {"LT", 60},
      {"ucirc", 0x00fb},
      {"Xi", 0x039e},
      {"larr", 0x2190},
      {"icirc", 0x00ee},
      {"or", 0x22a6},
      {"ecirc", 0x00ea},
      {"zwj", 0x200d},
      {"le", 0x2264},
      {"real", 0x211c},
      {"ocirc", 0x00f4},
      {"frac14", 0x00bc},
      {"euro", 0x20ac},
      {"rceil", 0x2309},
      {"frac12", 0x00bd},
      {"iexcl", 0x00a1},
      {"frac34", 0x00be},
      {"Nu", 0x039d},
      {"lceil", 0x2308},
      {"darr", 0x2193},
      {"loz", 0x25ca},
      {"mu", 0x03bc},
      {"macr", 0x00af},
      {"radic", 0x221a},
      {"para", 0x00b6},
      {"cap", 0x2229},
      {"pi", 0x03c0},
      {"cup", 0x222a},
      {"lrm", 0x200e},
      {"rlm", 0x200f},
      {"uml", 0x00a8},
      {"auml", 0x00e4},
      {"Prime", 0x2033},
      {"forall", 0x2200},
      {"uuml", 0x00fc},
      {"iuml", 0x00ef},
      {"rfloor", 0x230b},
      {"micro", 0x00b5},
      {"euml", 0x00eb},
      {"cedil", 0x00b8},
      {"ETH", 0x00d0},
      {"Yuml", 0x0178},
      {"Ecirc", 0x00ca},
      {"ccedil", 0x00e7},
      {"ouml", 0x00f6},
      {"Ucirc", 0x00db},
      {"lfloor", 0x230a},
      {"ge", 0x2265},
      {"reg", 0x00ae},
      {"weierp", 0x2118},
      {"ordf", 0x00aa},
      {"nu", 0x03bd},
      {"Icirc", 0x00ce},
      {"ni", 0x220b},
      {"Ccedil", 0x00c7},
      {"ne", 0x2260},
      {"aelig", 0x00e6},
      {"curren", 0x00a4},
      {"Gamma", 0x0393},
      {"piv", 0x03d6},
      {"Ocirc", 0x00d4},
      {"rcaron", 0x0159},
      {"amp", 38},
      {"zwnj", 0x200c},
      {"ccaron", 0x010d},
      {"Tcaron", 0x0164},
      {"ordm", 0x00ba},
      {"kappa", 0x03ba},
      {"Rcaron", 0x0158},
      {"yuml", 0x00ff},
      {"Kappa", 0x039a},
      {"ecaron", 0x011b},
      {"harr", 0x2194},
      {"oelig", 0x0153},
      {"Zcaron", 0x017d},
      {"prod", 0x220f},
      {"Phi", 0x03a6},
      {"prime", 0x2032},
      {"Ccaron", 0x010c},
      {"chi", 0x03c7},
      {"perp", 0x22a5},
      {"zcaron", 0x017e},
      {"copy", 0x00a9},
      {"agrave", 0x00e0},
      {"deg", 0x00b0},
      {"prop", 0x221d},
      {"oline", 0x203e},
      {"ugrave", 0x00f9},
      {"and", 0x22a5},
      {"igrave", 0x00ec},
      {"rho", 0x03c1},
      {"Euml", 0x00cb},
      {"raquo", 0x00bb},
      {"permil", 0x2030},
      {"Scaron", 0x0160},
      {"Chi", 0x03a7},
      {"Uuml", 0x00dc},
      {"image", 0x2111},
      {"egrave", 0x00e8},
      {"Ncaron", 0x0147},
      {"Rho", 0x03a1},
      {"Iuml", 0x00cf},
      {"ograve", 0x00f2},
      {"yen", 0x00a5},
      {"bull", 0x2022},
      {"laquo", 0x00ab},
      {"fnof", 0x0192},
      {"THORN", 0x00de},
      {"omega", 0x03c9},
      {"dcaron", 0x10f},
      {"tau", 0x03c4},
      {"divide", 0x00f7},
      {"ang", 0x2220},
      {"rang", 0x232a},
      {"Sigma", 0x03a3},
      {"Ouml", 0x00d6},
      {"eta", 0x03b7},
      {"Beta", 0x0392},
      {"aring", 0x00e5},
      {"Dcaron", 0x010e},
      {"lt", 60},
      {"uring", 0x016f},
      {"acute", 0x00b4},
      {"aacute", 0x00e1},
      {"uacute", 0x00fa},
      {"lang", 0x2329},
      {"iacute", 0x00ed},
      {"iota", 0x03b9},
      {"gamma", 0x03b3},
      {"Ecaron", 0x011a},
      {"Zeta", 0x0396},
      {"equiv", 0x2261},
      {"omicron", 0x03bf},
      {"phi", 0x03c6},
      {"cong", 0x2245},
      {"eacute", 0x00e9},
      {"QUOT", 34},
      {"rdquo", 0x201d},
      {"Yacute", 0x00dd},
      {"zeta", 0x03b6},
      {"oacute", 0x00f3},
      {"alpha", 0x03b1},
      {"AMP", 38},
      {"rArr", 0x21d2},
      {"ncaron", 0x0148},
      {"uArr", 0x21d1},
      {"ldquo", 0x201c},
      {"Egrave", 0x00c8},
      {"Acirc", 0x00c2},
      {"Ugrave", 0x00d9},
      {"lArr", 0x21d0},
      {"infin", 0x221e},
      {"dagger", 0x2020},
      {"pound", 0x00a3},
      {"Igrave", 0x00cc},
      {"part", 0x2202},
      {"trade", 0x2122},
      {"hellip", 0x2026},
      {"Dagger", 0x2021},
      {"nabla", 0x2207},
      {"yacute", 0x00fd},
      {"Lambda", 0x039b},
      {"Eta", 0x0397},
      {"delta", 0x03b4},
      {"Ograve", 0x00d2},
      {"gt", 62},
      {"tilde", 0x02dc},
      {"atilde", 0x00e3},
      {"lambda", 0x03bb},
      {"Omega", 0x03a9},
      {"Delta", 0x0394},
      {"dArr", 0x21d3},
      {"Uring", 0x016e},
      {"Eacute", 0x00c9},
      {"Uacute", 0x00da},
      {"int", 0x222b},
      {"otilde", 0x00f5},
      {"Iacute", 0x00cd},
      {"Iota", 0x0399},
      {"Psi", 0x03a8},
      {"cent", 0x00a2},
      {"not", 0x00ac},
      {"Auml", 0x00c4},
      {"OElig", 0x0152},
      {"Omicron", 0x039f},
      {"tcaron", 0x0165},
      {"Ntilde", 0x00d1},
      {"Oacute", 0x00d3},
      {"eth", 0x00f0},
      {"beta", 0x03b2},
      {"frasl", 0x2044},
      {"brvbar", 0x00a6},
      {"quot", 34},
      {"Theta", 0x0398},
      {"there4", 0x2234},
      {"sum", 0x2211},
      {"bdquo", 0x201e},
      {"sim", 0x223c},
      {"sup", 0x2283},
      {"sup1", 0x00b9},
      {"psi", 0x03c8},
      {"hArr", 0x21d4},
      {"percnt", 0x0025},
      {"sup2", 0x00b2},
      {"sup3", 0x00b3},
      {"ntilde", 0x00f1},
      {"supe", 0x2287},
      {"middot", 0x00b7},
      {"Agrave", 0x00c0},
      {"apos", 0x0027},
      {"empty", 0x2205},
      {"Otilde", 0x00d5},
      {"oplus", 0x2295},
      {"isin", 0x2208},
      {"notin", 0x2209},
      {"diams", 0x2666},
      {"AElig", 0x00c6},
      {"scaron", 0x0161},
      {"Aring", 0x00c5},
      {"szlig", 0x00df},
      {"Aacute", 0x00c1},
      {"emsp", 0x2003},
      {"sub", 0x2282},
      {"thorn", 0x00fe},
      {"sigma", 0x03c3},
      {"Alpha", 0x0391},
      {"sube", 0x2286},
      {"rsquo", 0x2019},
      {"rsaquo", 0x203a},
      {"clubs", 0x2663},
      {"minus", 0x2212},
      {"lsquo", 0x2018},
      {"lsaquo", 0x2039},
      {"alefsym", 0x2135},
      {"sigmaf", 0x03c2},
      {"ensp", 0x2002},
      {"asymp", 0x2248},
      {"sect", 0x00a7},
      {"shy", 0x00ad},
      {"exist", 0x2203},
      {"Atilde", 0x00c3},
      {"upsilon", 0x03c5},
      {"upsih", 0x03d2},
      {"lowast", 0x2217},
      {"theta", 0x03b8},
      {"epsilon", 0x03b5},
      {"nsub", 0x2284},
      {"plusmn", 0x00b1},
      {"mdash", 0x2014},
      {"sdot", 0x22c5},
      {"times", 0x00d7},
      {"otimes", 0x2297},
      {"Epsilon", 0x0395},
      {"ndash", 0x2013},
      {"Upsilon", 0x03a5},
      {"sbquo", 0x201a},
      {"nbsp", 0x00a0},
      {"hearts", 0x2665},
      {"iquest", 0x00bf},
      {"spades", 0x2660},
      {"oslash", 0x00f8},
      {"thinsp", 0x2009},
      {"Oslash", 0x00d8},
      {"thetasym", 0x03d1}
    };

  static const short lookup[] =
    {
        -1,   -1,   -1,   -1,    0,   -1,   -1,    1,
        -1,    2,    3,   -1,    4,   -1,   -1,   -1,
        -1,    5,   -1,   -1,   -1,   -1,    6,    7,
         8,    9,   -1,   10,   -1,   -1,   11,   -1,
        12,   -1,   13,   14,   -1,   -1,   -1,   -1,
        -1,   -1,   15,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   16,   -1,   -1,   17,   -1,   -1,
        -1,   18,   -1,   19,   -1,   -1,   -1,   -1,
        -1,   20,   21,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   22,   23,   24,   -1,   -1,   -1,
        25,   26,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   27,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   28,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   29,   -1,   -1,   -1,   30,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   31,
        -1,   32,   33,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   34,   -1,   -1,   -1,   35,
        -1,   -1,   -1,   36,   37,   -1,   -1,   -1,
        -1, -429, -236,   -2,   -1,   -1,   40,   41,
        42,   43,   -1,   -1,   44,   -1,   -1,   -1,
        -1,   45,   -1,   46,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   47,   -1,   -1,   -1,
        48,   49,   -1,   -1,   50,   51,   52,   53,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   54,
        55,   56,   57,   58,   -1,   -1,   59,   -1,
        -1,   60,   -1,   -1,   61,   -1,   -1,   62,
        -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   64,   -1,   -1,   -1,   -1,   -1,
        65,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   66,   67,   -1,
        -1,   -1,   68,   -1,   -1,   69,   -1,   70,
        71,   -1,   72,   73,   -1,   74,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   75,
        -1,   -1,   76,   77,   78,   -1,   -1,   79,
        80,   81,   -1,   -1,   82,   83,   84,   -1,
        -1,   85,   -1,   -1,   -1,   86,   -1,   87,
        88,   -1,   89,   90,   -1,   91,   -1,   -1,
        92,   -1,   -1,   -1,   -1,   -1,   -1,   93,
        -1,   94,   95,   96,   97,   -1,   98,   -1,
        -1,   99,   -1,  100,  101,  102,  103,   -1,
        -1,   -1,   -1,  104,   -1,  105,  106,  107,
       108,   -1,   -1,   -1,   -1,  109,   -1,  110,
        -1,   -1,   -1,   -1,   -1,  111,   -1,  112,
        -1,  113,  114,  115,   -1,   -1,   -1,  116,
       117,   -1,   -1,   -1,   -1,  118,  119,   -1,
        -1,   -1,   -1,   -1,   -1,  120,   -1,   -1,
       121,   -1,   -1,   -1,   -1,   -1,   -1,  122,
       123,  124,   -1,   -1,   -1,  125,   -1,   -1,
        -1,  126,  127,  128,  129,  130,   -1,   -1,
       131,   -1,   -1,   -1,   -1,  132,  133,   -1,
        -1,   -1,   -1,  134,   -1,   -1,  135,   -1,
       136,   -1,   -1,  137,  138,  139,   -1,   -1,
       140,  141,   -1,  142,  143,  144,   -1,  145,
        -1,   -1,  146,  147,  148,   -1,   -1,  149,
        -1,   -1,   -1,   -1,   -1,   -1,  150,   -1,
        -1,   -1,  151,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,  152,  153,   -1,  154,   -1,   -1,
       155,  156,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  157,   -1,   -1,   -1,
       158,   -1,   -1,   -1,   -1,   -1,  159,   -1,
        -1,  160,  161,  162,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  163,  164,   -1,   -1,
       165,  166,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  167,   -1,   -1,   -1,
        -1,  168,   -1,   -1,   -1,  169,  170,   -1,
        -1,   -1,   -1,  171,   -1,  172,   -1,  173,
        -1,   -1,   -1,   -1,   -1,  174,  175,   -1,
        -1,  176,  177,   -1,   -1,   -1,   -1,  178,
        -1,   -1,   -1,  179,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  180,   -1,   -1,
        -1,  181,  182,  183,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  184,   -1,  185,
        -1,   -1,  186,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  187,   -1,   -1,  188,
        -1,   -1,   -1,  189,  190,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  191,  192,  193,
        -1,  194,   -1,   -1,   -1,  195,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,  196,
        -1,   -1,   -1,   -1,  197,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  198,   -1,   -1,   -1,   -1,   -1,  199,
       200,  201,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  202,  203,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  204,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  205,   -1,
       206,   -1,   -1,  207,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  208,  209,   -1,
        -1,   -1,  210,  211,   -1,  212,   -1,   -1,
       213,   -1,   -1,   -1,   -1,  214,   -1,  215,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,  216,
        -1,  217,   -1,   -1,   -1,   -1,  218,   -1,
        -1,  219,  220,   -1,   -1,   -1,   -1,   -1,
       221,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  222,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  223,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  224,   -1,
        -1,   -1,   -1,  225,   -1,   -1,   -1,   -1,
       226,   -1,   -1,   -1,   -1,   -1,  227,   -1,
        -1,   -1,  228,   -1,   -1,   -1,   -1,  229,
        -1,   -1,   -1,   -1,   -1,  230,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,  231,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  232,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,  233,
        -1,   -1,   -1,   -1,  234,   -1,   -1,   -1,
        -1,  235,   -1,   -1,   -1,  236,   -1,   -1,
        -1,   -1,   -1,  237,  238,   -1,   -1,   -1,
       239,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,  240,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  241,  242,  243,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  244,   -1,   -1,  245,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,  246,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,  247,   -1,   -1,
        -1,  248,   -1,   -1,   -1,   -1,   -1,   -1,
       249,  250,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  251,   -1,
        -1,  252,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  253,   -1,   -1,   -1,
       254,   -1,  255,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  256,   -1,  257,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  258,   -1,   -1,   -1,  259,   -1,   -1,
        -1,   -1,   -1,  260,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  261,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  263,   -1,
       264,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       265,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,  266,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,  267,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,  268,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       269,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       270,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,  272,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
        -1,  273
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash_Entity (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register int index = lookup[key];

          if (index >= 0)
            {
              register const char *s = wordlist_Entity[index].name;

              if (*str == *s && !strncmp (str + 1, s + 1, len - 1) && s[len] == '\0')
                return &wordlist_Entity[index];
            }
          else if (index < -TOTAL_KEYWORDS)
            {
              register int offset = - 1 - TOTAL_KEYWORDS - index;
              register const struct entity *wordptr = &wordlist_Entity[TOTAL_KEYWORDS + lookup[offset]];
              register const struct entity *wordendptr = wordptr + -lookup[offset + 1];

              while (wordptr < wordendptr)
                {
                  register const char *s = wordptr->name;

                  if (*str == *s && !strncmp (str + 1, s + 1, len - 1) && s[len] == '\0')
                    return wordptr;
                  wordptr++;
                }
            }
        }
    }
  return 0;
}

