/***************************************************************************
                            HTMLSelectElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLSELECTELEMENT_H
#define HTMLSELECTELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 The select element allows the selection of an option. The contained
 options can be directly accessed through the select element as a
 collection. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html edef]-SELECT">
 SELECT element definition </a> in HTML 4.0.

 
 @short 
 The select element allows the selection of an option.
*/
@class HTMLCollection; 
@class HTMLFormElement; 

@interface HTMLSelectElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 The type of control created.

     
*/
- (NSString *) type;

/** 
 The ordinal index of the selected option. The value -1 is
 returned if no element is selected. If multiple options are
 selected, the index of the first selected option is returned.

     
*/
- (long) selectedIndex;

/** 
 see @ref selectedIndex
     
*/
- setSelectedIndex: (long)arg1;

/** 
 The current form control value.

     
*/
- (NSString *) value;

/** 
 see @ref value
     
*/
- setValue: (NSString *)arg1;

/** 
 The number of options in this <code> SELECT </code> .

     
*/
- (long) length;

/** 
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
- (HTMLFormElement*) form;

/** 
 The collection of <code> OPTION </code> elements contained by
 this element.

     
*/
- (HTMLCollection*) options;

/** 
 The control is unavailable in this context. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-disabled">
 disabled attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) disabled;

/** 
 see @ref disabled
     
*/
- setDisabled: (BOOL)arg1;

/** 
 If true, multiple <code> OPTION </code> elements may be
 selected in this <code> SELECT </code> . See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-multiple">
 multiple attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) multiple;

/** 
 see @ref multiple
     
*/
- setMultiple: (BOOL)arg1;

/** 
 Form control or object name when submitted with a form. See the
 <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-name-SELECT">
 name attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) name;

/** 
 see @ref name
     
*/
- setName: (NSString *)arg1;

/** 
 Number of visible rows. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-size-SELECT">
 size attribute definition </a> in HTML 4.0.

     
*/
- (long) size;

/** 
 see @ref size
     
*/
- setSize: (long)arg1;

/** 
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
- (long) tabIndex;

/** 
 see @ref tabIndex
     
*/
- setTabIndex: (long)arg1;

/** 
 Add a new element to the collection of <code> OPTION </code>
 elements for this <code> SELECT </code> .

     
*/
- add: (HTMLElement*)element before: (HTMLElement*)before;

/** 
 Remove an element from the collection of <code> OPTION </code>
 elements for this <code> SELECT </code> . Does nothing if no
 element has the given index.

     
*/
- remove: (long)index;

/** 
 Removes keyboard focus from this element.

     
*/
- blur;

/** 
 Gives keyboard focus to this element.

     
*/
- focus;
@end

#endif
