/***************************************************************************
                            HTMLParamElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLPARAMELEMENT_H
#define HTMLPARAMELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 Parameters fed to the <code> OBJECT </code> element. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html edef]-PARAM">
 PARAM element definition </a> in HTML 4.0.

 
 @short 
 Parameters fed to the <code> OBJECT </code> element.
*/

@interface HTMLParamElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 The name of a run-time parameter. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-name-PARAM">
 name attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) name;

/** 
 see @ref name
     
*/
- setName: (NSString *)arg1;

/** 
 Content type for the <code> value </code> attribute when <code>
 valuetype </code> has the value "ref". See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-type-PARAM">
 type attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) type;

/** 
 see @ref type
     
*/
- setType: (NSString *)arg1;

/** 
 The value of a run-time parameter. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-value-PARAM">
 value attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) value;

/** 
 see @ref value
     
*/
- setValue: (NSString *)arg1;

/** 
 Information about the meaning of the <code> value </code>
 attribute value. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-valuetype">
 valuetype attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) valueType;

/** 
 see @ref valueType
     
*/
- setValueType: (NSString *)arg1;
@end

#endif
