#include "NewClass.moc"
#include "NewClassBase.h"
#include <qwidget.h>
#include <qlabel.h>
#include <klocale.h>
#include <kapplication.h>
#include <qtooltip.h>
#include <kmessagebox.h>

NewClass::NewClass(QWidget * parent, char * wname)
 : KDialogBase(parent, wname, true, i18n("Add New User Class"),
                KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true)
{
	mWidget = new NewClassBase(this);
	setMainWidget(mWidget);

	QToolTip::add(mWidget->lbl1,i18n("The name of your new user class -\nmay be anything, but may not contain whitespaces."));
	QToolTip::add(mWidget->name_edit,i18n("The name of your new user class -\nmay be anything, but may not contain whitespaces."));
	QToolTip::add(mWidget->anon,i18n("Anonymous users\n(login=ftp or anonymous)"));
	QToolTip::add(mWidget->guest,i18n("Guest users\n(chrooted real users)"));
	QToolTip::add(mWidget->real,i18n("Real users"));
	QToolTip::add(mWidget->addrglob,i18n("Specify the addresses for this user class here;\nmay be globbed:\n* = any address\n*.localdomain.com = any address in localdomain.com\n127.0.0.* = IPs 127.0.0.1-127.0.0.255\n..."));
	QToolTip::add(mWidget->lbl2,i18n("Specify the addresses for this user class here;\nmay be globbed:\n* = any address\n*.localdomain.com = any address in localdomain.com\n127.0.0.* = IPs 127.0.0.1-127.0.0.255\n..."));

        mWidget->name_edit->setFocus();
}
NewClass::~NewClass()
{
}

void NewClass::slotOk()
{
	ftpclass *newclass;
	QString cn=mWidget->name_edit->text();
	QString ad=mWidget->addrglob->text();
	if(cn.isEmpty()) {
		KMessageBox::sorry(this, i18n("Class name may not be empty."));
		return;
	}
	if(cn.find(' ') != -1 || cn.find('\t') != -1) 
	{
		KMessageBox::sorry(this, i18n("Class name may not contain whitespaces"));
		return;
	}
	if(!mWidget->anon->isChecked() && 
	   !mWidget->guest->isChecked() && 
	   !mWidget->real->isChecked()) 
	{
		KMessageBox::sorry(this, i18n("You must check at least one of Anonymous, Guest or Real!"));
		return;
	}
	if(ad.isEmpty()) 
	{
		if(KMessageBox::warningYesNo(this,
			i18n("Addresses can not be empty. Assume '*'?"))==KMessageBox::Yes)
		{
			mWidget->addrglob->setText("*");
		}
	}

	ad=mWidget->addrglob->text();
	if(ad.isEmpty())
		return;

	newclass=new ftpclass;
	newclass->setName(cn);
	newclass->setAnon(mWidget->anon->isChecked());
	newclass->setGuest(mWidget->guest->isChecked());
	newclass->setReal(mWidget->real->isChecked());
	newclass->setAddrs(ad);
	emit classAdded(newclass);
	accept();
}
