/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmprototypemanager.h"
#include "pmallobjects.h"
#include "pmglobals.h"

PMPrototypeManager* PMPrototypeManager::s_pManager = 0;
KStaticDeleter<PMPrototypeManager> PMPrototypeManager::s_staticDeleter;

PMPrototypeManager::PMPrototypeManager( )
      : m_dict( 43 )
{
   m_prototypes.setAutoDelete( true );
   m_prototypes.append( new PMScene( ) );
   m_prototypes.append( new PMGlobalSettings( ) );
   m_prototypes.append( new PMBox( ) );
   m_prototypes.append( new PMSphere( ) );
   m_prototypes.append( new PMCylinder( ) );
   m_prototypes.append( new PMCone( ) );
   m_prototypes.append( new PMTorus( ) );
   m_prototypes.append( new PMLathe( ) );
   m_prototypes.append( new PMPrism( ) );
   
   m_prototypes.append( new PMSurfaceOfRevolution( ) );
   m_prototypes.append( new PMSuperquadricEllipsoid( ) );
   m_prototypes.append( new PMHeightField( ) );
   m_prototypes.append( new PMText( ) );
   m_prototypes.append( new PMJuliaFractal( ) );
   
   m_prototypes.append( new PMBlob( ) );
   m_prototypes.append( new PMBlobSphere( ) );
   m_prototypes.append( new PMBlobCylinder( ) );
   
   m_prototypes.append( new PMPlane( ) );
   m_prototypes.append( new PMPolynom( ) );
   
   m_prototypes.append( new PMCSG( ) );
   m_prototypes.append( new PMDeclare( ) );
   m_prototypes.append( new PMObjectLink( ) );
   
   m_prototypes.append( new PMDisc( ) );
   m_prototypes.append( new PMBicubicPatch( ) );
   m_prototypes.append( new PMTriangle( ) );

   m_prototypes.append( new PMBoundedBy( ) );
   m_prototypes.append( new PMClippedBy( ) );
   
   m_prototypes.append( new PMTranslate( ) );
   m_prototypes.append( new PMScale( ) );
   m_prototypes.append( new PMRotate( ) );
   m_prototypes.append( new PMPovrayMatrix( ) );
   m_prototypes.append( new PMComment( ) );
   m_prototypes.append( new PMRaw( ) );
   m_prototypes.append( new PMCamera( ) );
   m_prototypes.append( new PMLight( ) );
   m_prototypes.append( new PMLooksLike( ) );
   
   m_prototypes.append( new PMTexture( ) );
   m_prototypes.append( new PMPigment( ) );
   m_prototypes.append( new PMSolidColor( ) );
   m_prototypes.append( new PMNormal( ) );   
   m_prototypes.append( new PMFinish( ) );
   m_prototypes.append( new PMTexture( ) );
   m_prototypes.append( new PMPattern( ) );
   m_prototypes.append( new PMBlendMapModifiers( ) );
   m_prototypes.append( new PMImageMap( ) );
   m_prototypes.append( new PMTextureMap( ) );   
   m_prototypes.append( new PMColorMap( ) );   
   m_prototypes.append( new PMPigmentMap( ) );
   m_prototypes.append( new PMNormalMap( ) );   
   m_prototypes.append( new PMSlopeMap( ) );   
   m_prototypes.append( new PMDensityMap( ) );   
   m_prototypes.append( new PMMaterialMap( ) );   
   m_prototypes.append( new PMBumpMap( ) );
   m_prototypes.append( new PMTextureList( ) );
   m_prototypes.append( new PMColorList( ) );
   m_prototypes.append( new PMPigmentList( ) );
   m_prototypes.append( new PMNormalList( ) );
   m_prototypes.append( new PMDensityList( ) );
   m_prototypes.append( new PMWarp( ) );
   m_prototypes.append( new PMQuickColor( ) );	
   m_prototypes.append( new PMSlope( ) );	
   m_prototypes.append( new PMSkySphere( ) );	
   m_prototypes.append( new PMRainbow( ) );	
   m_prototypes.append( new PMFog( ) );	
   m_prototypes.append( new PMInterior( ) );	
   m_prototypes.append( new PMMedia( ) );
   m_prototypes.append( new PMMaterial( ) );
   m_prototypes.append( new PMDensity( ) );

   PMObjectListIterator it( m_prototypes );
   for( ; it.current( ); ++it )
      m_dict.insert( (*it)->className( ), *it );
}

PMPrototypeManager::~PMPrototypeManager( )
{
   PMObjectListIterator it( m_prototypes );
   for( ; it.current( ); ++it )
      it.current( )->cleanUp( );
   
   m_dict.clear( );
   m_prototypes.clear( );
}

PMPrototypeManager* PMPrototypeManager::theManager( )
{
   if( !s_pManager )
      s_staticDeleter.setObject( s_pManager, new PMPrototypeManager( ) );
   return s_pManager;
}

PMObjectListIterator PMPrototypeManager::prototypeIterator( ) const
{
   return PMObjectListIterator( m_prototypes );
}

void PMPrototypeManager::addPrototype( PMObject* obj )
{
   PMObjectListIterator it( m_prototypes );
   bool found = false;

   for( ; it.current( ) && !found; ++it )
      if( it.current( )->type( ) == obj->type( ) )
         found = true;

   if( !found )
      m_prototypes.append( obj );
}

PMObject* PMPrototypeManager::newObject( const PMObjectType type ) const
{
   PMObjectListIterator it( m_prototypes );
   bool found = false;

   for( ; it.current( ) && !found; ++it )
      if( it.current( )->type( ) == type )
         return it.current( )->newObject( );

   return 0;
}

PMObject* PMPrototypeManager::newObject( const QString& name ) const
{
   PMObject* obj = m_dict.find( name );
   if( !obj )
      return 0;
   return obj->newObject( );
}

PMObjectType PMPrototypeManager::objectType( const QString& name ) const
{
   PMObject* obj = m_dict.find( name );
   if( !obj )
      return PMTNone;
   return obj->type( );
}
