//////////////////////////////////////////////////////////////
// 	$Id: rpmInterface.h,v 1.21.2.1 2002/12/13 15:20:22 toivo Exp $
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef RPM_IFACE_H
#define RPM_IFACE_H

#include "../config.h"

#ifdef HAVE_RPM
#include <sys/types.h>
/* stupid RPM headers! */
typedef __off64_t off64_t;
#include <rpm/rpmlib.h>
#else
  typedef struct  Header{
};
#endif

#include <qptrlist.h>

#include "packageInfo.h"
#include "pkgInterface.h"

class KDir;
class cacheObj;

class RPM : public pkgInterface
{
 Q_OBJECT

public:
  RPM();
  ~RPM();

  bool isType(char *buf, const QString &fname);

  packageInfo *getPackageInfo(char mode, const QString &name, const QString &version);
  QStringList getFileList(packageInfo *p);
  QStringList depends(const QString &name, int src);
  QStringList verify(packageInfo *p, const QStringList &files);

  QString uninstall(int uninstallFlags, QPtrList<packageInfo> *p, bool &test);
  QString uninstall(int uninstallFlags, packageInfo *p, bool &test);
  QString doUninst(int uninstallFlags, const QStringList &files, bool &test);
  QString doUninstP(int uninstallFlags, const QStringList &files, bool &test);

  QString install(int installFlags, QPtrList<packageInfo> *p, bool &test);
  QString install(int installFlags, packageInfo *p, bool &test);
  QString doinst(int installFlags, const QStringList &files, bool &test);
  QString doinstP(int installFlags, const QStringList &files, bool &test);

  QStringList FindFile(const QString &name);
  void collectDepends(packageInfo *p, const QString &name, int src);
  bool parseName(const QString &name, QString *n, QString *v);

  QString provMap(QString p);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

private:
#ifdef HAVE_RPM
  packageInfo* collectInfo(Header h);
#else
  packageInfo* collectInfo(QStringList &ln);
#endif
  QStringList collectFileList(Header h);
  void listInstalledPackages(QPtrList<packageInfo> *pki);

  QDict<QString> provides;
  bool rpmSetup;
  QStringList infoList;

#ifndef HAVE_RPM
  QString packageQuery();
  
  QStringList getIFileList(packageInfo *p);
  QStringList getUFileList(QString fn);

  packageInfo *getIPackageInfo( QString name);
  packageInfo *getUPackageInfo( QString name);

  QString quotePath( QString path);
#endif

 };

#endif



