/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapLongBufferR;
import java.nio.LongBuffer;

class HeapLongBuffer
extends LongBuffer {
    HeapLongBuffer(int n2, int n3) {
        super(-1, 0, n3, n2, new long[n2], 0);
    }

    HeapLongBuffer(long[] lArray, int n2, int n3) {
        super(-1, n2, n2 + n3, lArray.length, lArray, 0);
    }

    protected HeapLongBuffer(long[] lArray, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5, lArray, n6);
    }

    public LongBuffer slice() {
        return new HeapLongBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    public LongBuffer duplicate() {
        return new HeapLongBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public LongBuffer asReadOnlyBuffer() {
        return new HeapLongBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n2) {
        return n2 + this.offset;
    }

    public long get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    public long get(int n2) {
        return this.hb[this.ix(this.checkIndex(n2))];
    }

    public LongBuffer get(long[] lArray, int n2, int n3) {
        Buffer.checkBounds(n2, n3, lArray.length);
        if (n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), lArray, n2, n3);
        this.position(this.position() + n3);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public LongBuffer put(long l2) {
        this.hb[this.ix((int)this.nextPutIndex())] = l2;
        return this;
    }

    public LongBuffer put(int n2, long l2) {
        this.hb[this.ix((int)this.checkIndex((int)n2))] = l2;
        return this;
    }

    public LongBuffer put(long[] lArray, int n2, int n3) {
        Buffer.checkBounds(n2, n3, lArray.length);
        if (n3 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(lArray, n2, this.hb, this.ix(this.position()), n3);
        this.position(this.position() + n3);
        return this;
    }

    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer instanceof HeapLongBuffer) {
            if (longBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapLongBuffer heapLongBuffer = (HeapLongBuffer)longBuffer;
            int n2 = heapLongBuffer.remaining();
            if (n2 > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapLongBuffer.hb, heapLongBuffer.ix(heapLongBuffer.position()), this.hb, this.ix(this.position()), n2);
            heapLongBuffer.position(heapLongBuffer.position() + n2);
            this.position(this.position() + n2);
        } else if (longBuffer.isDirect()) {
            int n3 = longBuffer.remaining();
            if (n3 > this.remaining()) {
                throw new BufferOverflowException();
            }
            longBuffer.get(this.hb, this.ix(this.position()), n3);
            this.position(this.position() + n3);
        } else {
            super.put(longBuffer);
        }
        return this;
    }

    public LongBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

