/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.FactoryURLClassLoader;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.net.www.ParseUtil;

public class URLClassLoader
extends SecureClassLoader {
    private URLClassPath ucp;
    private AccessControlContext acc;

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray);
        this.acc = AccessController.getContext();
    }

    public URLClassLoader(URL[] uRLArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray);
        this.acc = AccessController.getContext();
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray, uRLStreamHandlerFactory);
        this.acc = AccessController.getContext();
    }

    protected void addURL(URL uRL) {
        this.ucp.addURL(uRL);
    }

    public URL[] getURLs() {
        return this.ucp.getURLs();
    }

    protected Class findClass(final String string) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String string2 = string.replace('.', '/').concat(".class");
                    Resource resource = URLClassLoader.this.ucp.getResource(string2, false);
                    if (resource != null) {
                        try {
                            return URLClassLoader.this.defineClass(string, resource);
                        }
                        catch (IOException iOException) {
                            throw new ClassNotFoundException(string, iOException);
                        }
                    }
                    throw new ClassNotFoundException(string);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    private Class defineClass(String string, Resource resource) throws IOException {
        Object object;
        Certificate[] certificateArray;
        Object object2;
        int n2 = string.lastIndexOf(46);
        URL uRL = resource.getCodeSourceURL();
        if (n2 != -1) {
            object2 = string.substring(0, n2);
            certificateArray = this.getPackage((String)object2);
            object = resource.getManifest();
            if (certificateArray != null) {
                if (certificateArray.isSealed()) {
                    if (!certificateArray.isSealed(uRL)) {
                        throw new SecurityException("sealing violation: package " + (String)object2 + " is sealed");
                    }
                } else if (object != null && this.isSealed((String)object2, (Manifest)object)) {
                    throw new SecurityException("sealing violation: can't seal package " + (String)object2 + ": already loaded");
                }
            } else if (object != null) {
                this.definePackage((String)object2, (Manifest)object, uRL);
            } else {
                this.definePackage((String)object2, null, null, null, null, null, null, null);
            }
        }
        object2 = resource.getBytes();
        certificateArray = resource.getCertificates();
        object = new CodeSource(uRL, certificateArray);
        return this.defineClass(string, (byte[])object2, 0, ((byte[])object2).length, (CodeSource)object);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    public URL findResource(final String string) {
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URLClassLoader.this.ucp.findResource(string, true);
            }
        }, this.acc);
        return uRL != null ? this.ucp.checkURL(uRL) : null;
    }

    public Enumeration findResources(String string) throws IOException {
        final Enumeration enumeration = this.ucp.findResources(string, true);
        return new Enumeration(){
            private URL url = null;

            private boolean next() {
                URL uRL;
                if (this.url != null) {
                    return true;
                }
                while ((uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object run() {
                        if (!3.access$200(this.this$1).hasMoreElements()) {
                            return null;
                        }
                        return 3.access$200(this.this$1).nextElement();
                    }
                }, URLClassLoader.this.acc)) != null) {
                    this.url = URLClassLoader.this.ucp.checkURL(uRL);
                    if (this.url == null) continue;
                }
                return this.url != null;
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.url;
                this.url = null;
                return uRL;
            }

            public boolean hasMoreElements() {
                return this.next();
            }

            static /* synthetic */ Enumeration access$200(3 var0) {
                return var0.enumeration;
            }
        };
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Object object;
        Object object2;
        Permission permission;
        URLConnection uRLConnection;
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        try {
            uRLConnection = uRL.openConnection();
            permission = uRLConnection.getPermission();
        }
        catch (IOException iOException) {
            permission = null;
            uRLConnection = null;
        }
        if (permission instanceof FilePermission) {
            object2 = permission.getName();
            if (((String)object2).endsWith(File.separator)) {
                object2 = (String)object2 + "-";
                permission = new FilePermission((String)object2, "read");
            }
        } else if (permission == null && uRL.getProtocol().equals("file")) {
            object2 = uRL.getFile().replace('/', File.separatorChar);
            if (((String)(object2 = ParseUtil.decode((String)object2))).endsWith(File.separator)) {
                object2 = (String)object2 + "-";
            }
            permission = new FilePermission((String)object2, "read");
        } else {
            object2 = uRL;
            if (uRLConnection instanceof JarURLConnection) {
                object2 = ((JarURLConnection)uRLConnection).getJarFileURL();
            }
            if ((object = ((URL)object2).getHost()) == null) {
                object = "localhost";
            }
            permission = new SocketPermission((String)object, "connect, accept");
        }
        if (permission != null) {
            object2 = System.getSecurityManager();
            if (object2 != null) {
                object = permission;
                AccessController.doPrivileged(new PrivilegedAction((SecurityManager)object2, (Permission)object){
                    private final /* synthetic */ SecurityManager val$sm;
                    private final /* synthetic */ Permission val$fp;
                    {
                        this.val$sm = securityManager;
                        this.val$fp = permission;
                    }

                    public Object run() throws SecurityException {
                        this.val$sm.checkPermission(this.val$fp);
                        return null;
                    }
                }, this.acc);
            }
            permissionCollection.add(permission);
        }
        return permissionCollection;
    }

    public static URLClassLoader newInstance(final URL[] uRLArray, final ClassLoader classLoader) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(uRLArray, classLoader);
            }
        });
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }

    public static URLClassLoader newInstance(final URL[] uRLArray) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(uRLArray);
            }
        });
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }
}

