/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import sun.plugin.cache.Cache;
import sun.plugin.cache.CachedFile;
import sun.plugin.cache.CachedFileLoader;
import sun.plugin.usability.UserProfile;

public class FileCache {
    protected static File directory;
    protected static Hashtable loadedFiles;
    protected static ReferenceQueue refQueue;
    protected static final String[] exts;
    protected static long lastCacheModifyTime;
    protected static Hashtable filesInCache;

    public static void init() {
    }

    public static CachedFile get(URL uRL) throws IOException {
        CachedFile cachedFile;
        block6: {
            cachedFile = null;
            if (Cache.cachingDisabled) {
                return null;
            }
            if (!FileCache.isSupported(uRL)) break block6;
            FileReference fileReference = (FileReference)loadedFiles.get(uRL);
            if (fileReference != null) {
                cachedFile = (CachedFile)fileReference.get();
            }
            if (cachedFile == null) {
                try {
                    cachedFile = new CachedFileLoader(uRL).load();
                    loadedFiles.put(uRL, new FileReference(cachedFile, refQueue, uRL));
                    while ((fileReference = (FileReference)refQueue.poll()) != null) {
                        loadedFiles.remove(fileReference.getURL());
                    }
                }
                catch (IOException iOException) {
                    Cache.msgPrintln("cache.cache_warning", new Object[]{uRL});
                    cachedFile = null;
                }
            }
        }
        return cachedFile;
    }

    protected static final boolean isSupported(URL uRL) {
        String string;
        boolean bl = false;
        if (Cache.isSupportedProtocol(uRL) && (string = Cache.getFileExtension(uRL.toString())) != null) {
            int n = 0;
            while (n < exts.length) {
                if (string.equalsIgnoreCase(exts[n])) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    protected static final File getDataFile(File file, URL uRL) {
        String string = file.getName();
        string = string.substring(0, string.length() - ".idx".length());
        string = string + Cache.getFileExtension(uRL.toString());
        return new File(file.getParentFile(), string);
    }

    protected static String generateCacheFileName(URL uRL) throws IOException {
        return Cache.generateCacheFileName(directory, uRL);
    }

    protected static Enumeration getMatchingFiles(URL uRL) {
        return Cache.getMatchingFiles(directory, uRL);
    }

    public static void clearLoadedFiles() {
        loadedFiles.clear();
        while (refQueue.poll() != null) {
        }
    }

    protected static boolean getMatchingFile(CachedFileLoader cachedFileLoader) throws IOException {
        boolean bl = false;
        String string = Cache.getKey(cachedFileLoader.getURL());
        bl = FileCache.match(cachedFileLoader, string);
        if (!bl && Cache.updateTable(directory, filesInCache, string)) {
            bl = FileCache.match(cachedFileLoader, string);
        }
        return bl;
    }

    protected static boolean match(CachedFileLoader cachedFileLoader, String string) throws IOException {
        boolean bl = false;
        ArrayList arrayList = (ArrayList)filesInCache.get(string);
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                File file = (File)arrayList.get(n);
                File file2 = FileCache.getDataFile(file, cachedFileLoader.getURL());
                if (file.exists() && file2.exists()) {
                    bl = FileCache.verifyFile(file, cachedFileLoader);
                } else {
                    arrayList.remove(n);
                    if (arrayList.size() == 0) {
                        filesInCache.remove(string);
                    }
                }
                if (bl) {
                    cachedFileLoader.setDataFile(file2);
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static boolean verifyFile(File file, CachedFileLoader cachedFileLoader) throws IOException {
        boolean bl;
        block9: {
            RandomAccessFile randomAccessFile;
            block8: {
                String string;
                bl = false;
                randomAccessFile = new RandomAccessFile(file, "r");
                if (randomAccessFile.readByte() != 16 || !(string = randomAccessFile.readUTF()).equals(cachedFileLoader.getURL().toString())) break block8;
                bl = true;
                cachedFileLoader.setIndexFile(file);
                cachedFileLoader.setLastModify(randomAccessFile.readLong());
                cachedFileLoader.setExpiration(randomAccessFile.readLong());
                randomAccessFile.readInt();
                cachedFileLoader.setHeaderMap(FileCache.readHeaderFields(randomAccessFile));
            }
            Object var6_6 = null;
            try {
                randomAccessFile.close();
                randomAccessFile = null;
            }
            catch (IOException iOException) {}
            break block9;
            {
                catch (IOException iOException) {
                    Object var6_7 = null;
                    try {
                        randomAccessFile.close();
                        randomAccessFile = null;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    randomAccessFile.close();
                    randomAccessFile = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap readHeaderFields(RandomAccessFile randomAccessFile) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(randomAccessFile.getFD()));
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        try {
            int n = dataInputStream.readInt();
            while (n > 0) {
                hashMap.put(dataInputStream.readUTF(), dataInputStream.readUTF());
                --n;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
        return hashMap;
    }

    static {
        loadedFiles = new Hashtable();
        refQueue = new ReferenceQueue();
        exts = new String[]{".class", ".gif", ".jpg", ".au", ".wav"};
        lastCacheModifyTime = 0L;
        filesInCache = new Hashtable();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Cache.init();
                if (!Cache.cachingDisabled) {
                    directory = null;
                    String string = UserProfile.getNewFileCacheDir();
                    if (string != null) {
                        directory = new File(string.trim());
                    }
                    boolean bl = false;
                    if (directory != null) {
                        bl = directory.exists();
                        if (!bl) {
                            bl = directory.mkdirs();
                            if (!bl) {
                                Cache.msgPrintln("cache.create_warning", new Object[]{directory});
                            }
                        } else if (!directory.canRead()) {
                            bl = false;
                            Cache.msgPrintln("cache.read_warning", new Object[]{directory});
                        } else if (!directory.canWrite()) {
                            bl = false;
                            Cache.msgPrintln("cache.write_warning", new Object[]{directory});
                        } else if (!directory.isDirectory()) {
                            bl = false;
                            Cache.msgPrintln("cache.directory_warning", new Object[]{directory});
                        }
                    }
                    if (bl) {
                        Cache.createTable(directory, filesInCache);
                    }
                }
                return null;
            }
        });
    }

    protected static class FileReference
    extends WeakReference {
        URL url;

        public FileReference(Object object, ReferenceQueue referenceQueue, URL uRL) {
            super(object, referenceQueue);
            this.url = uRL;
        }

        public URL getURL() {
            return this.url;
        }
    }
}

