/*
    Copyright (C) 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include <errno.h>

#include <qapplication.h>
#include <qframe.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qwhatsthis.h>
#include <qtooltip.h>
#include <qimage.h>
#include <klineedit.h>
#include <qpushbutton.h>
#include <qfileinfo.h>
#include <qinputdialog.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <kconfig.h>
#include <krun.h>
#include <kdebug.h>


#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <kurlrequester.h>

#include "optiondialog.h"
#include "optiondialog.moc"
#include "cddata.h"

static const char* const optiondialog_image0_data[] = {
"183 33 102 2",
"Qt c None",
".m c #003873",
".K c #003c73",
".P c #083c73",
"#s c #083c7b",
".v c #08407b",
"#b c #08447b",
".1 c #10407b",
".C c #10447b",
".l c #10487b",
".e c #184883",
".E c #184c83",
".n c #185083",
".d c #205083",
".f c #205583",
".0 c #20558b",
".u c #29558b",
".V c #29598b",
"#l c #295d8b",
".I c #315d8b",
".2 c #31618b",
"#t c #316194",
".s c #396194",
".B c #396594",
"#. c #396994",
".R c #416994",
"#p c #416d94",
".T c #416d9c",
".c c #41719c",
"#f c #4a6d9c",
"#z c #4a719c",
".g c #4a759c",
"#u c #52759c",
"#i c #5275a4",
"#E c #52799c",
".8 c #5279a4",
"#G c #527da4",
"#a c #5a79a4",
".N c #5a7da4",
".k c #5a81a4",
".A c #6281a4",
"#r c #6281ac",
".O c #6285ac",
".F c #6289ac",
".Q c #6a89ac",
"#g c #6a8dac",
"#m c #6a8db4",
".7 c #738db4",
".L c #7391b4",
".o c #7395b4",
".J c #7b95b4",
"#d c #7b99b4",
"#D c #7b99bd",
".z c #8399bd",
".H c #839dbd",
".b c #83a1bd",
".w c #8ba1bd",
"#e c #8ba5bd",
".D c #8ba5c5",
"#H c #8baac5",
".5 c #94a5c5",
".h c #94aac5",
".M c #94aec5",
"#h c #9caec5",
".y c #9cb2c5",
".G c #9cb2cd",
".x c #9cb6cd",
".6 c #a4b6cd",
"#k c #a4bacd",
"#B c #acbacd",
".3 c #acbed5",
"#I c #acc2d5",
".W c #b4c2d5",
".4 c #b4c6d5",
"#F c #bdc6d5",
"#C c #bdc6de",
".r c #bdcade",
"#A c #bdcede",
"#w c #c5cede",
".Y c #c5d2de",
"#v c #c5d2e6",
"#y c #cdd2e6",
".a c #cdd6e6",
"#x c #cddae6",
".t c #d5dae6",
"#n c #d5dee6",
".i c #d5deee",
"#J c #d5e2ee",
".j c #dee2ee",
"## c #dee6ee",
"#o c #e6e6ee",
".9 c #e6eaee",
".U c #e6eaf6",
".p c #e6eef6",
".S c #eeeef6",
".Z c #eef2f6",
"#c c #f6f2f6",
"#q c #f6f6f6",
".X c #f6f6ff",
"#j c #f6faff",
".# c #fffaff",
".q c #ffffff",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQt.#.a.b.c.d.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.e.f.g.h.iQtQtQtQtQtQtQt",
"QtQtQtQtQt.j.k.l.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.n.o.pQtQtQtQtQt",
"QtQtQt.q.r.f.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.s.t.qQtQtQt",
"QtQtQt.r.e.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.u.tQtQtQt",
"QtQt.j.f.m.m.m.m.m.v.w.x.x.x.x.x.x.x.x.x.x.y.z.A.B.v.m.m.m.m.C.w.x.x.x.x.x.B.m.m.B.x.x.x.x.x.D.E.m.m.F.x.x.x.x.x.x.x.x.x.G.H.k.I.m.m.m.m.m.v.J.x.x.x.x.J.m.m.m.m.K.L.x.x.x.x.M.u.m.m.m.m.m.m.m.m.m.m.N.x.x.x.x.x.x.x.x.x.y.H.O.s.P.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.E.g.Q.w.y.x.x.x.h.e.m.m.m.m.R.SQtQt",
"Qt.#.k.m.m.m.m.m.m.T.qQtQtQtQtQtQtQtQtQtQtQtQt.q.#.j.O.m.m.m.g.qQtQtQtQt.U.V.m.m.WQtQtQtQtQt.r.v.m.P.SQtQtQtQtQtQtQtQtQtQtQt.q.X.Y.T.m.m.m.I.ZQtQtQtQt.X.k.m.m.m.0.UQtQtQtQt.t.1.m.m.m.m.m.m.m.m.m.l.aQtQtQtQtQtQtQtQtQtQtQt.q.#.i.N.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.2.3.Z.#.qQtQtQtQtQt.4.v.m.m.m.m.m.HQtQt",
"Qt.a.l.m.m.m.m.m.m.5.U.U.U.U.U.U.U.U.U.S.#QtQtQtQtQt.S.C.m.m.6QtQtQtQtQt.3.m.m.u.SQtQtQtQtQt.7.m.m.8QtQtQtQtQtQtQtQtQtQtQtQtQtQtQt.9.E.m.m.HQtQtQtQtQtQt.j.n.m.m.Q.qQtQtQtQt.z.m.m.m.m.m.m.m.m.m.m.R.#QtQtQtQtQtQtQtQtQtQtQtQtQtQt.U.I.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m#.##QtQtQtQtQt.#.S.U.U.O.m.m.m.m.m.m.u.9Qt",
"Qt.b.m.m.m.m.m.m.m.d.T.N.N.N.N.N.2.V.V.I.hQtQtQtQtQt.9.v.m.V.UQtQtQtQt.##a.m.m.J.qQtQtQtQt.S.f.m.K.3QtQtQtQtQt.Y.L.L.w##QtQtQtQtQt.#.B.m.e.tQtQtQtQtQtQt.q.6.K#b.YQtQtQtQt.p.I.m.m.m.m.m.m.m.m.m.m.GQtQtQtQtQt#c.w#d#e.9QtQtQtQtQt.##f.m.m.m.m.P.e.V.R.8.Q.g.m.m.m.C.B.Q.w.G.G.G#e#g.B.v.m.m.m.m.m.P.V.8#d#h.G.G.h.J#i.E.m.m.m.m.m#b.YQtQtQtQt#j#k#f#l.V.V.v.m.m.m.m.m.m.K.3Qt",
"Qt.T.m.m.m.m.m.m.m.K.6.#.#.#.#.U.C.m#b.V.rQtQtQtQt.#.z.m.m#m.qQtQtQtQt.t.e.m.m#nQtQtQtQtQt.3.P.m.0.ZQtQtQtQt.q.N.m.m.v.6QtQtQtQtQt#o.C.m.g#jQtQtQtQtQtQtQt.q.8#p#qQtQtQtQt.W.P.m.m.m.m.m.m.m.m.m.f.jQtQtQtQtQt.4.m.m.m.6QtQtQtQtQt.9.V.m.m.V.J.W.t.XQtQtQt#g.m.K.A.Y#jQtQtQtQtQtQtQt.#.4.V.m.m.m.I.6.SQtQtQtQtQtQtQtQt.j#r.m.m.R.A.w#jQtQtQtQt#n.Q.A.A.A.2.m.m.m.m.m.m.m.m.LQt",
"Qt.E.m.m.m.m.m.m.m.E.SQtQtQtQt.G.m#s.r.XQtQtQtQt#j.h#b.m.K.tQtQtQtQtQt.h.m.m#t.qQtQtQtQtQt.8.m.m.JQtQtQtQtQt.S.z.h.h.W.XQtQtQtQt#j.Q.m.m.WQtQtQtQtQtQtQtQtQt##.rQtQtQtQtQt#u.m.1.V.V.V.V.V.V.C.m.O.qQtQtQtQt#j#i.m.E.Q.SQtQtQtQtQt#h.m.C.y#cQtQtQtQtQtQt.Z#t.m.h.qQtQtQtQt.a.jQtQtQtQtQt.6.m.m.T.SQtQtQtQt.S#v.#QtQtQtQt.S.f.e.tQtQtQtQtQtQtQtQtQtQtQtQt#u.m.m.m.m.m.m.m.m#fQt",
"Qt.e.m.m.m.m.m.m.m#dQtQtQtQt.X.T.m.T.XQtQtQtQt.S.g.m.m.m#p.XQtQtQtQt.X#l.m.m.yQtQtQtQtQt.U#b.m.C.aQtQtQtQtQt.H#hQtQtQtQtQtQtQt.j.N.m.m.u.SQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt#n.e.m#hQtQtQtQtQt.#.V.m#wQtQtQtQtQt#x.8.qQtQtQtQtQtQtQt.Y.E.u#nQtQtQtQtQtQt.S.3.L.C.JQtQtQtQtQt.6.m.OQtQtQtQtQt.r.v.V.SQtQtQtQt.S.E.E.UQtQtQtQtQt#t.8.qQtQtQtQtQtQtQtQtQtQtQt.S.P.m.m.m.m.m.m.m.m.BQt",
"Qt.E.m.m.m.m.m.m.C#yQtQtQtQt.a.v.m.H.XQtQtQtQt.q.i.u.m.m.GQtQtQtQtQt.r.v.m.C.9QtQtQtQtQt.h.m.m#f.qQtQtQtQt.Z.2.8.#QtQtQtQt.9.N.l.m.m.m.J.qQtQtQtQt#k.jQtQtQtQtQtQtQtQtQt.H.m.n#oQtQtQtQtQt#w.m.B.ZQtQtQtQtQt#d.3QtQtQtQtQtQt.X.G.E.e#wQtQtQtQt.q#v.8.C.K.m.u.SQtQtQtQt#q.B.m.3QtQtQtQtQt.M#s#kQtQtQtQtQt.h.m.8#jQtQtQtQt#o.n#z.H#AQtQtQtQt.q.M.H.H.H.H.k.m.m.m.m.m.m.m.m.m.TQt",
"Qt#..m.m.m.m.m.m.g.#QtQtQtQt.J.m.m.E#i.SQtQtQtQtQt#u.m.C.ZQtQtQtQtQt.6.m.K.JQtQtQtQtQt.#.B.m.m.GQtQtQtQtQt.3.m.C.ZQtQtQtQt.9.C.m.m.m.m.iQtQtQtQt.q.I.N.XQtQtQtQtQtQtQt.#.V.m.n.J.J.J.J.J.J.R.m.hQtQtQtQtQt.U#i.t.9##.j.a#B.L#t.K.m.Q.qQtQtQtQt.W.E.m.m.m.m.HQtQtQtQtQt.a.m.V.ZQtQtQtQt#j#..I.SQtQtQtQt.Z#..m.WQtQtQtQtQt.M.K.m.P.4QtQtQtQt#o.K.m.m.m.m.v#b#b.v.m.m#s.m.m.m.FQt",
"Qt.o.m.m.m.m.m.m#kQtQtQtQt.Z#z.E.E.u.h.#QtQtQtQt.j.0.m.8.qQtQtQtQtQt.S.4.r#cQtQtQtQtQt#C.K.m.u#oQtQtQtQt.#.8.m.m.rQtQtQtQtQt#t.m.m.m.T.#QtQtQtQt#w.v.v#hQtQtQtQtQtQtQt.W.P.m.m.m.m.m.m.m.m.m.v##QtQtQtQtQt.6.C#l.V.0.d.v.m.m.m.m#s#wQtQtQtQt.j.V.m.m.m.m.v#AQtQtQtQtQt.L.m.z.qQtQtQtQt.x#s.QQtQtQtQtQt#n.v.V.XQtQtQtQt.U.u.m.m.d.XQtQtQtQt#e.m.m.m.m.m.B.z.N.L#f.v.w.K.m.m.6Qt",
"Qt#A.v.m.m.m.m#l.UQtQtQtQt.#.p.U.U#cQtQtQtQtQt.#.7.m.m#r.qQtQtQtQtQtQtQtQtQtQtQtQt.q#n.V.m.m.O.qQtQtQtQt#x.C.m.m.J.qQtQtQtQt.L.m.m.m.GQtQtQtQtQt.L.m.m.f.jQtQtQtQtQt.q.N.m.m.m.m.m.m.m.m.m.m.N.#QtQtQtQt.q.R.m.m.m.m.m.m.m.m.m.m.B.ZQtQtQtQt#D.m.m.m.m.m#s.rQtQtQtQtQt#w.6#qQtQtQt.q.a.e.m.F.qQtQtQtQt.S.G.tQtQtQtQt.X.g.m.m.m.LQtQtQtQt#q.R.m.m.m.m.m.m.N.C.Q#d#u.D.K.m.n.jQt",
"Qt.##z.m.m.m.m.LQtQtQtQtQtQtQtQtQtQtQtQtQtQt.a#E.m.m.m.v#F.qQtQtQtQtQtQtQtQtQtQt.S#e.E.m.m.K#wQtQtQtQtQt.J.m.m.m.s.ZQtQtQtQt.4#s.m.e.ZQtQtQtQt.q.E.m.m.m#uQtQtQtQtQt.9.v.m.m.m.m.m.m.m.m.m.m.3QtQtQtQtQt.Y#b.m.m.m.m.m.m.m.m.m.m.hQtQtQtQt#q.V.m.m.m.m.m.m#z.SQtQtQtQtQtQtQtQtQt.Z.H.v.m.m.l.4QtQtQtQtQtQtQtQtQt.##F.s.m.m.m.v.rQtQtQtQt.a.P.m.m.m.m.m.m.N.C#r.z.J.o.K.m#mQtQt",
"QtQt.a.e.m.m.m.8.L.L.L.L.L.L.L.L.L.L.L.L.N.V.P.m.m.m.m.m.K.R#d.G.W#C#F.W.6.h.7.R#b.m.m.m.m.C.Q.L.L.L.L.L.e.m.m.m.v.F.L.L.L.L.A.v.m.f.L.L.L.L.L.k.m.m.m.m.m.k.L.L.L.L.g.m.m.m.m.m.m.m.m.m.m.m.L.L.L.L.L.L#..m.m.m.m.m.m.m.m.m.m.m.k.L.L.L.L#G.K.m.m.m.m.m.m.m.E.F.M.3.r.r.W.G.H.g.l.m.m.m.m.m.v#z.w.6#C.r#C.6#H.O.u.K.m.m.m.m#b.Q.L.L.L.L.R.m.m.m.m.m.m.m.V#s.V.u.I#t.m#l#oQtQt",
"QtQt.q.G.v.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.P.v.v.P.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.P.v.v#s.m.m.m.m.m.m.m.m.m.m.m.m.m.v.v.v.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.l#AQtQtQt",
"QtQtQt.#.M.C.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.E.4.qQtQtQt",
"QtQtQtQt.q.Y.B.P.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.v#z#nQtQtQtQtQt",
"QtQtQtQtQtQt#j#I.N.n.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.m.u.O#A.qQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQt.#.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.j.jQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQt.#.#.#.#QtQt.q.#.#.#.#.#QtQt.q.#.#.#.#.qQtQt.q.#.#.#.#QtQtQt.#.#.#.#.qQtQtQtQtQtQtQtQt.#.#.#.#.qQtQt.q.qQtQt.q.qQtQt.q.#.#.#.#QtQt.#.#.#.#.qQt.q.#.#.#.#.qQt.q.#.#.#.#.qQtQtQtQtQtQtQtQt.#QtQtQt.#QtQtQt.#QtQtQt.#.qQtQt.#.#.#.#QtQtQtQt.#.#.#.#.qQtQt.#.#.#.#.qQtQtQt.#.#.#.#.qQtQt.q.qQtQt.q.qQtQt.q.qQtQt.q.#QtQtQt.#.#.#.#.qQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQt.Y.T#.#..g#nQt#w#.#.#.#..L#j#j#D#.#.#.#p.3QtQt.G#E.k.k.8.ZQt.S.O#.#.#p.GQtQtQtQtQtQtQt#j.T.k.k.8.6QtQt.r#eQtQt.4#HQtQt.G#.#.#..N.9.##m#.#.#.#eQt#n#f#.#..c.tQt#o.N.k.k#u#kQtQtQtQtQtQtQt.S.NQtQt.9.L.ZQt.S.k#vQt.##m.jQt.Z.O#.#..8.G.#QtQt.O#.#.#..hQtQt#D.8.k.k#g#qQt.S.T.k.k.8.WQtQt.h.WQtQt.h.4QtQt#H.o.XQt#x.oQtQt.p#E#.#.#p.WQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQt.D.8#k#k#D##Qt.q.X.4#f.X.XQt.S#..i.X.X.y.FQtQt#d.J.j#n.I#JQt#n#l#k#k.D.3QtQtQtQtQtQtQt.X.e.r.Y#D#mQtQt.6.OQtQt.x.QQtQt.J.J.j.S.X.q#j#..W##.Z#jQt.Y#..4.a.X.qQt.i.R.a.j#e.OQtQtQtQtQtQtQt.U.fQtQt.j.T.pQt.9.f#l.M.X.R#xQt.U#..i.X###f.6QtQt#l#k#w.U#jQtQt.8.G.j.j.d.UQt#o.d.j.j#D.LQtQt#m#hQtQt#g.GQtQt.F.d#p.i#A#zQtQt.Y.B.x#k#e.rQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQt#n.L.J.J.B.WQtQtQt#A#zQtQtQt.S#.#oQtQt.6.FQtQt#d.B.Q.F.O.XQt#c.w.J.J.N.OQtQtQtQtQtQtQt.X.C#d.H.N.hQtQt.6.OQtQt.x.QQtQt.J.I.8#wQtQt#j#..c#m.SQtQt.Y#l#d#hQtQtQt.i#l.k#l#..WQtQtQtQtQtQtQt.U.fQtQt.j.T.pQt.9#..r.8.F.2#xQt.U#..9Qt.q.F.HQtQt#l#m#e##QtQtQt.8#z#f.V.J.XQt#o.C.O.V.T#CQtQt#m#hQtQt#g.GQtQt.F.o.6.B.L#fQtQt#c.J.J.J#E.JQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQt.h.F.b.b.B.3QtQtQt#A#zQtQtQt.Z.R.o.b.b.8.LQtQt#d.DQtQtQtQtQt.i#i.b.b.k.kQtQtQtQtQtQtQt.X.C.H.b#G.LQtQt#I.B.b.b.8.oQtQt.J.b.Z.#QtQt#j#..Y#q.qQtQt.Y.I.z.b#e.9Qt.i.c.p.3.R.Y.qQtQtQtQtQtQt.S.V.b.b.L#..ZQt.9.R.U.S.L#b#xQt.U#t.o.b.J.R.aQtQt#l.L.b.b.rQtQt.8.4###z.h.XQt#o.u.q.G.g.a.qQt#d#E.b.b.B#kQtQt.F#DQt#w.s#.QtQt#w.N.b.b.8.LQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQt#o#B#k#k.3#qQtQtQt.S#wQtQtQt.q.a#k#k#k#B##QtQt.t#JQtQtQtQtQt.X.4#k#k#k.jQtQtQtQtQtQtQt.##k#k#k.3.UQtQt.Z#I#k#k#k.9QtQt.t#JQtQtQtQt.q.r.ZQtQtQtQt.S.3#k#k.3.SQt#c#A.#Qt.Y#w.qQtQtQtQtQtQt.q#w#k#k#k.YQtQt.X.r.XQt.#.4.ZQt#j.4#k#k#C#oQtQtQt.4#k#k#k.aQtQt.Y.UQt.9.3.ZQt.X.4Qt.q#A#v.qQt.9#B#k#k.3#cQtQt.a.tQtQt#o#AQtQt#q.3#k#k#B#oQtQtQtQtQtQtQtQtQtQtQt",
"QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"};

COptionDialog::COptionDialog( QWidget *parent, const char *name, bool modal ) : KDialogBase( IconList, i18n( "KOnCD - Setup" ), Help|Default|User1|Apply|Ok|Cancel, Ok, parent, name, modal = true, true ){
  setButtonText( User1, "A&udio CD" );

  setupDevices();
  setupOptions();
  setupPaths();
  setupUsers();

  setIconListAllVisible( true );
  resize( 520, 285 );

  connect( QPushButton_adduser, SIGNAL( clicked() ), this, SLOT( slot_addUser() ) );
  connect( QPushButton_deleteuser, SIGNAL( clicked() ), this, SLOT( slot_deleteUser() ) );

// Read the CD-Devices and add them to the ComboBoxes
	const char* arr[4];
	char buf[256];
	CDdata *CD = new CDdata;

	if ( QComboBox_cdwriterdev->count() ) QComboBox_cdwriterdev->clear();

	for( int i = 0; ! CD->getDev( i, &arr ); i++ ) {
		sprintf( buf, "%s %s", arr[0],arr[1] );
		QComboBox_cdwriterdev->insertItem( buf, i );
	}

	if ( QComboBox_cdreaderdev->count() ) QComboBox_cdreaderdev->clear();

	for( int i = 0; ! CD->getDev( i, &arr ); i++ ) {
		sprintf( buf, "%s %s", arr[0],arr[1] );
		QComboBox_cdreaderdev->insertItem( buf, i );
	}

	QComboBox_cdreaderdev->insertItem( "ATAPI CD-ROM ( /dev/cdrom )" );

	//Read config and display them in the ComboBoxes
	KConfig* config = kapp->config();

	config->setGroup("CD-Writer");
	QComboBox_cdwriterdev->setCurrentItem( config->readNumEntry("Index") );
	QComboBox_Fifosize->setCurrentItem( config->readNumEntry("Fifosize") );
	QCheckBox_BurnProof->setChecked( config->readBoolEntry("BurnProof") );

	config->setGroup("CD-Reader");
	QComboBox_cdreaderdev->setCurrentItem( config->readNumEntry("Index") );

	//Read program paths
	config->setGroup("Program paths");
	KURLRequester_cdrdao_path->lineEdit()->setText( config->readEntry("cdrdao_path") );
	KURLRequester_cdrecord_path->lineEdit()->setText( config->readEntry("cdrecord_path") );
	KURLRequester_mkisofs_path->lineEdit()->setText( config->readEntry("mkisofs_path") );
	KURLRequester_readcd_path->lineEdit()->setText( config->readEntry("readcd_path") );

  config->setGroup("General Options");
	QCheckBox_disableStartlogo->setChecked( config->readBoolEntry("DisableStartlogo") );

	//If user root ?
	if ( getuid() == 0 ){
		//Read users
		config->setGroup("Root config");
		if ( config->readEntry( "Users" ) == "" ) return;
		QStringList users = config->readListEntry( "Users" );
		QListBox_users->insertStringList( users, 0 );
		setCaption( i18n( "KOnCD - Setup (root mode)" ) );
		kdDebug() << "setup starting in root mode." << endl;
	}
	else {
    QPushButton_adduser->setEnabled( false );
    QPushButton_deleteuser->setEnabled( false );
    QListBox_users->setEnabled( false );
    kdDebug() << "setup starting in user mode." << endl;
	}
}

COptionDialog::~COptionDialog( void ){
}

void COptionDialog::setupDevices(){
	QFrame *page = addPage( i18n( "Devices" ), i18n( "Reader & writer devices" ), KGlobal::instance()->iconLoader()->loadIcon( "kcmdevices", KIcon::NoGroup , KIcon::SizeMedium ) );

  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
  if( topLayout == 0 ) return;

  QGroupBox *GroupBox1 = new QGroupBox( page, "GroupBox1" );
  GroupBox1->setFrameShape( QGroupBox::Box );
  GroupBox1->setFrameShadow( QGroupBox::Sunken );
  GroupBox1->setTitle( i18n( "Writer" ) );
  GroupBox1->setColumnLayout(0, Qt::Vertical );
  QHBoxLayout *GroupBox1Layout = new QHBoxLayout( GroupBox1->layout() );

  QComboBox_cdwriterdev = new QComboBox( false, GroupBox1, "QComboBox_cdwriterdev" );
  QWhatsThis::add( QComboBox_cdwriterdev, i18n( "Select the device for writing." ) );
  GroupBox1Layout->addWidget( QComboBox_cdwriterdev );

  QGroupBox *GroupBox2 = new QGroupBox( page, "GroupBox2" );
  GroupBox2->setFrameShape( QGroupBox::Box );
  GroupBox2->setFrameShadow( QGroupBox::Sunken );
  GroupBox2->setTitle( i18n( "Reader" ) );
  GroupBox2->setColumnLayout(0, Qt::Vertical );
  QHBoxLayout *GroupBox2Layout = new QHBoxLayout( GroupBox2->layout() );

  QComboBox_cdreaderdev = new QComboBox( false, GroupBox2, "QComboBox_cdreaderdev" );
  QWhatsThis::add( QComboBox_cdreaderdev, i18n( "Select the device for reading." ) );
  GroupBox2Layout->addWidget( QComboBox_cdreaderdev );

	topLayout->addWidget( GroupBox1 );
	topLayout->addWidget( GroupBox2 );
}

void COptionDialog::setupOptions(){
	QFrame *page = addPage( i18n( "Options" ), i18n( "Advanced options" ), KGlobal::instance()->iconLoader()->loadIcon( "configure", KIcon::NoGroup , KIcon::SizeMedium ) );

  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
  if( topLayout == 0 ) return;

  QGroupBox *GroupBox1 = new QGroupBox( page, "GroupBox1" );
  GroupBox1->setTitle( i18n( "Writer" ) );
  GroupBox1->setColumnLayout(0, Qt::Vertical );
  QVBoxLayout *GroupBox1Layout = new QVBoxLayout( GroupBox1->layout() );
  QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  GroupBox1Layout->addItem( spacer );

  QHBoxLayout *Layout7 = new QHBoxLayout( 0, 0, 6, "Layout7");

  QLabel *TextLabel1 = new QLabel( GroupBox1, "TextLabel1" );
  TextLabel1->setText( i18n( "Fifosize:" ) );
  Layout7->addWidget( TextLabel1 );
  QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Layout7->addItem( spacer_2 );

  QComboBox_Fifosize = new QComboBox( false, GroupBox1, "QComboBox_Fifosize" );
  QComboBox_Fifosize->insertItem( i18n( "4 MB" ) );
  QComboBox_Fifosize->insertItem( i18n( "8 MB" ) );
  QComboBox_Fifosize->insertItem( i18n( "12 MB" ) );
  QComboBox_Fifosize->insertItem( i18n( "16 MB" ) );
  QComboBox_Fifosize->insertItem( i18n( "20 MB" ) );
  QComboBox_Fifosize->insertItem( i18n( "24 MB" ) );
  QComboBox_Fifosize->insertItem( i18n( "28 MB" ) );
  QComboBox_Fifosize->insertItem( i18n( "32 MB" ) );
  QWhatsThis::add( QComboBox_Fifosize, i18n( "As a rule of thumb, the fifo size should be at least equal to the size of the internal buffer of the CD-Recorder and no more than half of the physical amount of RAM available in the machine. The recommended fifo size is between 4 and 32 MBytes." ) );
  Layout7->addWidget( QComboBox_Fifosize );
  QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Layout7->addItem( spacer_3 );
  GroupBox1Layout->addLayout( Layout7 );
  QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  GroupBox1Layout->addItem( spacer_4 );

  QFrame *Line1 = new QFrame( GroupBox1, "Line1" );
  Line1->setFrameShadow( QFrame::Sunken );
  Line1->setFrameShape( QFrame::HLine );
  GroupBox1Layout->addWidget( Line1 );
  QSpacerItem* spacer_5 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  GroupBox1Layout->addItem( spacer_5 );

  QHBoxLayout *Layout8 = new QHBoxLayout( 0, 0, 6, "Layout8");

  QCheckBox_BurnProof = new QCheckBox( GroupBox1, "QCheckBox_BurnProof" );
  QCheckBox_BurnProof->setText( i18n( "&Enable Burn-Proof" ) );
  QWhatsThis::add( QCheckBox_BurnProof, i18n( "Enables burn-proof, you need cdrecord 1.9 or later." ) );
  Layout8->addWidget( QCheckBox_BurnProof );
  QSpacerItem* spacer_6 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Layout8->addItem( spacer_6 );
  GroupBox1Layout->addLayout( Layout8 );
  QSpacerItem* spacer_7 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  GroupBox1Layout->addItem( spacer_7 );

  QHBoxLayout *Layout9 = new QHBoxLayout( 0, 0, 6, "Layout9");
  QSpacerItem* spacer_8 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Layout9->addItem( spacer_8 );

  QPixmap image0( ( const char** ) optiondialog_image0_data );
  QLabel *PixmapLabel = new QLabel( GroupBox1, "PixmapLabel" );
  PixmapLabel->setMinimumSize( QSize( 183, 33 ) );
  PixmapLabel->setMaximumSize( QSize( 183, 33 ) );
  PixmapLabel->setPixmap( image0 );
  PixmapLabel->setScaledContents( TRUE );
  QToolTip::add( PixmapLabel, i18n( "You need cdrecord 1.9 or later." ) );
  Layout9->addWidget( PixmapLabel );
  QSpacerItem* spacer_9 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Layout9->addItem( spacer_9 );
  GroupBox1Layout->addLayout( Layout9 );
  QSpacerItem* spacer_10 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  GroupBox1Layout->addItem( spacer_10 );

  QGroupBox *GroupBox2 = new QGroupBox( page, "GroupBox2" );
  GroupBox2->setTitle( i18n( "Other" ) );
  GroupBox2->setColumnLayout(0, Qt::Vertical );
  QVBoxLayout *GroupBox2Layout = new QVBoxLayout( GroupBox2->layout() );

  QHBoxLayout *Layout10 = new QHBoxLayout( 0, 0, 6, "Layout10");

  QCheckBox_disableStartlogo = new QCheckBox( GroupBox2, "QCheckBox_disableStartlogo" );
  QCheckBox_disableStartlogo->setText( i18n( "D&isable startlogo" ) );
  QWhatsThis::add( QCheckBox_disableStartlogo, i18n( "Disables the startlogo." ) );
  Layout10->addWidget( QCheckBox_disableStartlogo );
  QSpacerItem* spacer_11 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Layout10->addItem( spacer_11 );
  GroupBox2Layout->addLayout( Layout10 );

	topLayout->addWidget( GroupBox1 );
	topLayout->addWidget( GroupBox2 );
}

void COptionDialog::setupPaths(){
	QFrame *page = addPage( i18n( "Paths" ), i18n( "Paths to commandline programs" ), KGlobal::instance()->iconLoader()->loadIcon( "goto", KIcon::NoGroup , KIcon::SizeMedium ) );

  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
  if( topLayout == 0 ) return;

  QGroupBox *GroupBox = new QGroupBox( page, "GroupBox" );
  GroupBox->setTitle( QString::null );
  GroupBox->setColumnLayout(0, Qt::Vertical );
  GroupBox->layout()->setSpacing( 6 );
  GroupBox->layout()->setMargin( 11 );
  QHBoxLayout *GroupBoxLayout = new QHBoxLayout( GroupBox->layout() );

  QVBoxLayout *Layout1 = new QVBoxLayout( 0, 0, 6, "Layout1");

  QSpacerItem* spacer_1 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  Layout1->addItem( spacer_1 );

  QLabel *TextLabel1 = new QLabel( GroupBox, "TextLabel1" );
  TextLabel1->setText( i18n( "cdrecord:" ) );
  Layout1->addWidget( TextLabel1 );
  QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  Layout1->addItem( spacer_2 );

  QLabel *TextLabel2 = new QLabel( GroupBox, "TextLabel2" );
  TextLabel2->setText( i18n( "readcd:" ) );
  Layout1->addWidget( TextLabel2 );
  QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  Layout1->addItem( spacer_3 );

  QLabel *TextLabel3 = new QLabel( GroupBox, "TextLabel3" );
  TextLabel3->setText( i18n( "cdrdao:" ) );
  Layout1->addWidget( TextLabel3 );
  QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  Layout1->addItem( spacer_4 );

  QLabel *TextLabel4 = new QLabel( GroupBox, "TextLabel4" );
  TextLabel4->setText( i18n( "mkisofs:" ) );
  Layout1->addWidget( TextLabel4 );
  QSpacerItem* spacer_5 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  Layout1->addItem( spacer_5 );

  GroupBoxLayout->addLayout( Layout1 );

  QVBoxLayout *Layout2 = new QVBoxLayout( 0, 0, 6, "Layout2");

  QSpacerItem* spacer_6 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  Layout2->addItem( spacer_6 );

  KURLRequester_cdrecord_path = new KURLRequester( GroupBox, "QLineEdit_cdrecord_path" );
  KURLRequester_cdrecord_path->setMinimumSize( QSize( 150, 20 ) );
  Layout2->addWidget( KURLRequester_cdrecord_path );
  QSpacerItem* spacer_7 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  Layout2->addItem( spacer_7 );

  KURLRequester_readcd_path = new KURLRequester( GroupBox, "QLineEdit_readcd_path" );
  KURLRequester_readcd_path->setMinimumSize( QSize( 150, 20 ) );
  Layout2->addWidget( KURLRequester_readcd_path );
  QSpacerItem* spacer_8 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  Layout2->addItem( spacer_8 );

  KURLRequester_cdrdao_path = new KURLRequester( GroupBox, "QLineEdit_cdrdao_path" );
  KURLRequester_cdrdao_path->setMinimumSize( QSize( 150, 20 ) );
  Layout2->addWidget( KURLRequester_cdrdao_path );
  QSpacerItem* spacer_9 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  Layout2->addItem( spacer_9 );

  KURLRequester_mkisofs_path = new KURLRequester( GroupBox, "QLineEdit_mkisofs_path" );
  KURLRequester_mkisofs_path->setMinimumSize( QSize( 150, 20 ) );
  Layout2->addWidget( KURLRequester_mkisofs_path );
  QSpacerItem* spacer_10 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
  Layout2->addItem( spacer_10 );

  GroupBoxLayout->addLayout( Layout2 );

  topLayout->addWidget( GroupBox );
}

void COptionDialog::setupUsers(){
	QFrame *page = addPage( i18n( "Users" ), i18n( "Users for non root mode" ), KGlobal::instance()->iconLoader()->loadIcon( "personal", KIcon::NoGroup , KIcon::SizeMedium ) );

  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
  if( topLayout == 0 ) return;

  QGroupBox *GroupBox = new QGroupBox( page, "GroupBox" );
  GroupBox->setTitle( QString::null );
  GroupBox->setColumnLayout(0, Qt::Vertical );
  GroupBox->layout()->setSpacing( 6 );
  GroupBox->layout()->setMargin( 11 );
  QVBoxLayout *GroupBoxLayout = new QVBoxLayout( GroupBox->layout() );

  QListBox_users = new QListBox( GroupBox, "QListBox_users" );
  QWhatsThis::add( QListBox_users, i18n( "List of users for non-root mode. This may be changed by root only." ) );
  GroupBoxLayout->addWidget( QListBox_users );

  QHBoxLayout *Layout = new QHBoxLayout( 0, 0, 6, "Layout");
  QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Layout->addItem( spacer );

  QPushButton_adduser = new QPushButton( GroupBox, "QPushButton_adduser" );
  QPushButton_adduser->setMinimumSize( QSize( 50, 20 ) );
  QPushButton_adduser->setText( i18n( "&Add" ) );
  QWhatsThis::add( QPushButton_adduser, i18n( "Adds a new user." ) );
  Layout->addWidget( QPushButton_adduser );
  QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Layout->addItem( spacer_2 );

  QPushButton_deleteuser = new QPushButton( GroupBox, "QPushButton_deleteuser" );
  QPushButton_deleteuser->setMinimumSize( QSize( 50, 20 ) );
  QPushButton_deleteuser->setText( i18n( "De&lete" ) );
  QWhatsThis::add( QPushButton_deleteuser, i18n( "Deletes the selected user." ) );
  Layout->addWidget( QPushButton_deleteuser );
  QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Layout->addItem( spacer_3 );
  GroupBoxLayout->addLayout( Layout );

  topLayout->addWidget( GroupBox );
}

void COptionDialog::slot_addUser(){
	bool ok = true;
	QString user = QInputDialog::getText( i18n( "KOnCD - Add user" ), i18n( "Please enter a new user:" ), QLineEdit::Normal, QString::null, &ok, this );
	if ( ! ok ) return;
	QListBox_users->insertItem( user );
}

void COptionDialog::slot_deleteUser(){
  if( QListBox_users->currentItem() == -1 ) return;
	QListBox_users->removeItem( QListBox_users->currentItem() );
}

void COptionDialog::slotDefault( void ){
	QComboBox_cdwriterdev->setCurrentItem( 0 );
	QComboBox_cdreaderdev->setCurrentItem( 0 );
	QComboBox_Fifosize->setCurrentItem( 0 );
	QCheckBox_BurnProof->setChecked( false );
	KURLRequester_cdrdao_path->lineEdit()->setText( "/usr/bin/cdrdao" );
	KURLRequester_cdrecord_path->lineEdit()->setText( "/usr/bin/cdrecord" );
	KURLRequester_mkisofs_path->lineEdit()->setText( "/usr/bin/mkisofs" );
	KURLRequester_readcd_path->lineEdit()->setText( "/usr/bin/readcd" );
}

void COptionDialog::slotApply( void ){
	KConfig* config = kapp->config();
	CDdata *CD = new CDdata;

	//Save settings for CD-Writer
	config->setGroup("CD-Writer");
	config->writeEntry("Name", QComboBox_cdwriterdev->currentText());
	config->writeEntry("SCSI-Target", CD->getDevStr( QComboBox_cdwriterdev->currentItem() ));
	config->writeEntry("Index", QComboBox_cdwriterdev->currentItem());
	config->writeEntry("isRW", CD->isRW( QComboBox_cdwriterdev->currentItem() ));
	config->writeEntry("Fifosize", QComboBox_Fifosize->currentItem() );
	config->writeEntry("BurnProof", QCheckBox_BurnProof->isChecked() );
	QString buf = "/dev/scd";
	buf.append( config->readEntry("SCSI-Target").mid( 6, 1 ) );
	config->writeEntry( "Device", buf );

	//Save settings for CD-Reader
	config->setGroup("CD-Reader");
	config->writeEntry("Name", QComboBox_cdreaderdev->currentText());
	config->writeEntry("SCSI-Target", CD->getDevStr( QComboBox_cdreaderdev->currentItem() ));
	config->writeEntry("Index", QComboBox_cdreaderdev->currentItem());

	if ( config->readEntry("Name") == "ATAPI CD-ROM ( /dev/cdrom )" ) {
  	config->writeEntry("Device", "/dev/cdrom");
	}
	else {
		QString buf = "/dev/scd";
		buf.append( config->readEntry("SCSI-Target").mid( 6, 1 ) );
		config->writeEntry( "Device", buf );
	}

  config->setGroup("General Options");
	config->writeEntry("DisableStartlogo", QCheckBox_disableStartlogo->isChecked() );

	//Save program paths
	config->setGroup("Program paths");
	config->writeEntry("cdrdao_path", KURLRequester_cdrdao_path->lineEdit()->text());
	config->writeEntry("cdrecord_path", KURLRequester_cdrecord_path->lineEdit()->text());
	config->writeEntry("mkisofs_path", KURLRequester_mkisofs_path->lineEdit()->text());
	config->writeEntry("readcd_path", KURLRequester_readcd_path->lineEdit()->text());

	// For root only !
	if ( getuid() == 0 ) {
		rootOptions();
	}
}

void COptionDialog::rootOptions(){
  char buf[256];
	KConfig* config = kapp->config();

  //Save users
  config->setGroup("Root config");

  int tcount = 0;
	int tc = QListBox_users->count();
	QStringList users;
	do {
		users.append( QListBox_users->text( tcount ) );
		tcount++;
	}
	while ( tcount < tc );

	config->writeEntry("Users", users);

	//Set permissions for /dev/sg*
	char sg[10];
	tcount = 0;
	tc = 16;
	do {
		sprintf( sg, "/dev/sg%d", tcount );
		if ( chmod ( (const char*) sg, 0660 ) ) {
			sprintf( buf, I18N_NOOP( "Error: %s !\nPath: %s" ), strerror( errno ), (const char*) sg );
			KMessageBox::error( 0, buf, i18n("KOnCD - Setup - Error") );
			return;
		}
		tcount++;
	}
	while ( tcount < tc );

	//Add users to group from /dev/sg0
	QFileInfo file( "/dev/sg0" );
	tcount = 0;
	tc = QListBox_users->count();
	do {
		if ( KRun::runCommand( "usermod -G " + file.groupId() + ' ' + QListBox_users->text( tcount ) ) == 0 ) {
			KMessageBox::error( 0, i18n( "Could not add user to group of SCSI generic devices." ), i18n("KOnCD - Setup - Error") );
			return;
		}
		tcount++;
	}
	while ( tcount < tc );

	//Set user:group for cd reader device
	QString cdreader = "/dev/scd";

	config->setGroup("CD-Reader");
	cdreader.append( config->readEntry("SCSI-Target").mid( 6, 1 ) );

	QFileInfo file2( cdreader );
	tcount = 0;
	tc = QListBox_users->count();
	do {
		//if ( initgroups( QListBox_users->text( tcount ), file2.groupId() ) ) {
		if ( KRun::runCommand( "usermod -G " + file2.groupId() + ' ' + QListBox_users->text( tcount ) ) == 0 ) {
			KMessageBox::error( 0, i18n( "Could not add user to group of CD reader device!" ), i18n("KOnCD - Setup - Error") );
			return;
		}
		tcount++;
	}
	while ( tcount < tc );

	//Set permissions to cd reader device
	if ( KRun::runCommand( "chmod 0640 " + cdreader ) == 0 ) {
		KMessageBox::error( 0, i18n( "Could not set permissions to CD reader device!" ), i18n("KOnCD - Setup - Error") );
		return;
	}

	//Set user:group for commandline programs
	if ( KRun::runCommand( "chown root " + KURLRequester_cdrecord_path->lineEdit()->text() ) == 0 ) {
		KMessageBox::error( 0, i18n( "Could not set file owner of cdrecord!" ), i18n("KOnCD - Setup - Error") );
		return;
	}

	if ( KRun::runCommand( "chown root " + KURLRequester_cdrdao_path->lineEdit()->text() ) == 0 ) {
		KMessageBox::error( 0, i18n( "Could not set file owner of cdrdao!" ), i18n("KOnCD - Setup - Error") );
		return;
	}

	if ( KRun::runCommand( "chown root " + KURLRequester_mkisofs_path->lineEdit()->text() ) == 0 ) {
		KMessageBox::error( 0, i18n( "Could not set file owner of mkisofs!" ), i18n("KOnCD - Setup - Error") );
		return;
	}

	if ( KRun::runCommand( "chown root " + KURLRequester_readcd_path->lineEdit()->text() ) == 0 ) {
		KMessageBox::error( 0, i18n( "Could not set file owner of readcd!" ), i18n("KOnCD - Setup - Error") );
		return;
	}

	//Set permissions for commandline programs
	if ( KRun::runCommand( "chmod 4711 " + KURLRequester_cdrecord_path->lineEdit()->text() ) == 0 ) {
		KMessageBox::error( 0, i18n( "Could not set file access permissions of cdrecord!" ), i18n("KOnCD - Setup - Error") );
		return;
	}

	if ( KRun::runCommand( "chmod 4711 " + KURLRequester_cdrdao_path->lineEdit()->text() ) == 0 ) {
		KMessageBox::error( 0, i18n( "Could not set file access permissions of cdrdao!" ), i18n("KOnCD - Setup - Error") );
		return;
	}

	if ( KRun::runCommand( "chmod 4711 " +KURLRequester_mkisofs_path->lineEdit()->text() ) == 0 ) {
		KMessageBox::error( 0, i18n( "Could not set file access permissions of mkisofs!" ), i18n("KOnCD - Setup - Error") );
		return;
	}

	if ( KRun::runCommand( "chmod 4711 " + KURLRequester_readcd_path->lineEdit()->text() ) == 0 ) {
		KMessageBox::error( 0, i18n( "Could not set file access permissions of readcd!" ), i18n("KOnCD - Setup - Error") );
		return;
	}

	//All OK!
	KMessageBox::information( 0, i18n("KOnCD is ready for normal users now!"), i18n("KOnCD - Setup - Info") );
  kdDebug() << "root settings saved." << endl;
}

void COptionDialog::slotUser1( void ){
  KRun::runCommand( "kcmshell audiocd" );
}

void COptionDialog::slotOk( void ){
  slotApply();
  accept();
}
