/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifndef CDDATA_H
#define CDDATA_H

#include <qobject.h>
#include <kprocess.h>

/**
  *@author Kai Heitkamp
  */

struct DEVICES {
	short bus, dev, speed;
	char vendor[30], name[30], version[20], desc[50], devstr[20];
	bool cdrw;
	struct DEVICES *next;
};

class CDdata : public QObject{
	Q_OBJECT
public:
	CDdata( QObject * parent=0, const char * name=0 );
	~CDdata();
	bool isRW( int n );
	int eject( int n );
	int load( int n );
	int reset( int n );
	const QString showOutput();
	int getDev( int n, const char *(*arr)[4] );
	int getDevParams( int n, const short *(*arr)[3] );
	const char * getDevStr( int n );
private:
	bool HaveRights;
	char prog[128];
	KProcess proc;
	struct DEVICES *Devices;
	QString output;
	char dummystr[20];
private slots:
	void slotOutput(KProcess *p, char *s, int n);
	void slotOutput1(KProcess *p, char *s, int n);
};

#endif
