/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001 Michael Goffioul <goffioul@imec.be>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 **/

#ifndef UTIL_H
#define UTIL_H

#include <qstring.h>
#include <kurl.h>

KURL smbToUrl(const QString& work, const QString& server, const QString& printer);
void urlToSmb(const KURL& url, QString& work, QString& server, QString& printer);
// those 2 are only workarounds when the login/password may contain
// strange characters ('@', '/'). In this case, those chars are not encoded
// as other SMB tools (smbspool) doesn't seem to support encoding. This
// utilities allow to continue working KURL class (and encoding) within
// KDEPrint, but without encoding outside KDEPrint (shoudl fix bug #38733)
KURL smbToUrl(const QString& s);
QString urlToSmb(const KURL& url);

#endif
