/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.kde.kjas.server.KJASAppletClassLoader;
import org.kde.kjas.server.KJASAppletStub;
import org.kde.kjas.server.KJASSoundPlayer;
import org.kde.kjas.server.Main;

public class KJASAppletContext
implements AppletContext {
    private Hashtable stubs = new Hashtable();
    private Hashtable images = new Hashtable();
    private Hashtable streams = new Hashtable();
    private String myID;
    private KJASAppletClassLoader loader;
    private boolean active;
    private Object get_member_obj = null;
    private static final int JError = 0;
    private static final int JBoolean = 1;
    private static final int JFunction = 2;
    private static final int JNumber = 3;
    private static final int JObject = 4;
    private static final int JString = 5;
    private static final int JVoid = 6;

    public KJASAppletContext(String string) {
        this.myID = string;
        this.active = true;
    }

    public String getID() {
        return this.myID;
    }

    public void createApplet(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, Hashtable hashtable) {
        String string10 = new String("archive").toUpperCase();
        if (string6 == null) {
            if (hashtable.containsKey(string10)) {
                string6 = (String)hashtable.get(string10);
            }
        } else if (!hashtable.containsKey(string10)) {
            hashtable.put(string10, string6);
        }
        string10 = new String("codebase").toUpperCase();
        if (string5 == null && hashtable.containsKey(string10)) {
            string5 = (String)hashtable.get(string10);
        }
        if (!hashtable.containsKey(string10 = new String("width").toUpperCase())) {
            hashtable.put(string10, string7);
        }
        if (!hashtable.containsKey(string10 = new String("height").toUpperCase())) {
            hashtable.put(string10, string8);
        }
        try {
            Object object;
            KJASAppletClassLoader kJASAppletClassLoader = KJASAppletClassLoader.getLoader(string4, string5);
            if (string6 != null) {
                object = new StringTokenizer(string6, ",", false);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string11 = ((StringTokenizer)object).nextToken().trim();
                    kJASAppletClassLoader.addArchiveName(string11);
                }
            }
            kJASAppletClassLoader.paramsDone();
            object = new KJASAppletStub(this, string, kJASAppletClassLoader.getCodeBase(), kJASAppletClassLoader.getDocBase(), string2, string3, new Dimension(Integer.parseInt(string7), Integer.parseInt(string8)), hashtable, string9, kJASAppletClassLoader);
            this.stubs.put(string, object);
            ((KJASAppletStub)object).createApplet();
        }
        catch (Exception exception) {
            Main.kjas_err("Something bad happened in createApplet: " + exception, exception);
        }
    }

    public void initApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not init and show applet: " + string);
        } else {
            kJASAppletStub.initApplet();
        }
    }

    public void destroyApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not destroy applet: " + string);
        } else {
            Main.debug("stopping applet: " + string);
            kJASAppletStub.die();
            this.stubs.remove(string);
        }
    }

    public void startApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not start applet: " + string);
        } else {
            kJASAppletStub.startApplet();
        }
    }

    public void stopApplet(String string) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not stop applet: " + string);
        } else {
            kJASAppletStub.stopApplet();
        }
    }

    public void destroy() {
        Enumeration enumeration = this.stubs.elements();
        while (enumeration.hasMoreElements()) {
            KJASAppletStub kJASAppletStub = (KJASAppletStub)enumeration.nextElement();
            kJASAppletStub.die();
        }
        this.stubs.clear();
        this.active = false;
    }

    public Applet getApplet(String string) {
        if (this.active) {
            Enumeration enumeration = this.stubs.elements();
            while (enumeration.hasMoreElements()) {
                KJASAppletStub kJASAppletStub = (KJASAppletStub)enumeration.nextElement();
                if (!kJASAppletStub.getAppletName().equals(string)) continue;
                return kJASAppletStub.getApplet();
            }
        }
        return null;
    }

    public Enumeration getApplets() {
        if (this.active) {
            Vector<KJASAppletStub> vector = new Vector<KJASAppletStub>();
            Enumeration enumeration = this.stubs.elements();
            while (enumeration.hasMoreElements()) {
                KJASAppletStub kJASAppletStub = (KJASAppletStub)enumeration.nextElement();
                vector.add(kJASAppletStub);
            }
            return vector.elements();
        }
        return null;
    }

    public AudioClip getAudioClip(URL uRL) {
        Main.debug("getAudioClip, url = " + uRL);
        return new KJASSoundPlayer(uRL);
    }

    public void addImage(String string, byte[] byArray) {
        Main.debug("addImage for url = " + string);
        this.images.put(string, byArray);
    }

    public Image getImage(URL uRL) {
        if (this.active && uRL != null) {
            String string = uRL.toString();
            Main.debug("getImage, url = " + string);
            Main.protocol.sendGetURLDataCmd(this.myID, string);
            while (!this.images.containsKey(string) && this.active) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.images.containsKey(string)) {
                byte[] byArray = (byte[])this.images.get(string);
                if (byArray.length > 0) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    return toolkit.createImage(byArray);
                }
                return null;
            }
        }
        return null;
    }

    public void showDocument(URL uRL) {
        Main.debug("showDocument, url = " + uRL);
        if (this.active && uRL != null) {
            Main.protocol.sendShowDocumentCmd(this.myID, uRL.toString());
        }
    }

    public void showDocument(URL uRL, String string) {
        Main.debug("showDocument, url = " + uRL + " targetFrame = " + string);
        if (this.active && uRL != null && string != null) {
            Main.protocol.sendShowDocumentCmd(this.myID, uRL.toString(), string);
        }
    }

    public void showStatus(String string) {
        if (this.active && string != null) {
            Main.protocol.sendShowStatusCmd(this.myID, string);
        }
    }

    public String evaluateJavaScript(String string) {
        if (this.active && string != null) {
            Main.liveconnect_thread = Thread.currentThread();
            Main.protocol.sendEvaluateJavaScriptCmd(this.myID, string);
            try {
                Thread.currentThread();
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String string2 = Main.liveconnect_returnval;
            Main.liveconnect_returnval = null;
            return string2;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int findMember(Class var1_1, Object var2_2, String var3_3, StringBuffer var4_4) {
        if (var1_1 == null) {
            return 0;
        }
        try {
            try {
                var5_5 = var1_1.getField(var3_3);
                var6_8 = var5_5.get(var2_2);
                var4_4.insert(0, var6_8.toString());
                var7_10 = var5_5.getType().getName();
                if (var7_10.equals("boolean") || var7_10.equals("java.lang.Boolean")) {
                    return 1;
                }
                if (var7_10.equals("int") || var7_10.equals("long") || var7_10.equals("float") || var7_10.equals("double") || var6_8 instanceof Number) {
                    return 3;
                }
                if (var7_10.equals("java.lang.String")) {
                    return 5;
                }
                this.get_member_obj = var6_8;
                return 4;
            }
            catch (Exception var5_6) {
                var6_9 = var1_1.getDeclaredMethods();
                var7_11 = 0;
                ** while (var7_11 < var6_9.length)
            }
lbl-1000:
            // 1 sources

            {
                if (var6_9[var7_11].getName().equals(var3_3)) {
                    return 2;
                }
                ++var7_11;
                continue;
            }
lbl26:
            // 1 sources

            return this.findMember(var1_1.getSuperclass(), var2_2, var3_3, var4_4);
        }
        catch (Exception var5_7) {
            Main.debug("findMember throwed exception: " + var5_7.toString());
            return 0;
        }
    }

    public int getMember(String string, String string2, StringBuffer stringBuffer) {
        Object object;
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not get value of applet: " + string);
            return 0;
        }
        Main.debug("getMember: " + string2);
        int n = string2.lastIndexOf(46);
        if (n > -1) {
            object = this.get_member_obj;
            string2 = string2.substring(n + 1);
            Main.debug("getMember basename: " + string2);
        } else {
            object = kJASAppletStub.getApplet();
        }
        return this.findMember(object.getClass(), object, string2, stringBuffer);
    }

    private Method findMethod(Class clazz, String string, Class[] classArray) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            return method;
        }
        catch (Exception exception) {
            return this.findMethod(clazz.getSuperclass(), string, classArray);
        }
    }

    public int callMember(String string, String string2, StringBuffer stringBuffer, List list) {
        KJASAppletStub kJASAppletStub = (KJASAppletStub)this.stubs.get(string);
        if (kJASAppletStub == null) {
            Main.debug("could not get value of applet: " + string);
            return 0;
        }
        try {
            Object object;
            Main.debug("callMember: " + string2);
            int n = string2.lastIndexOf(46);
            if (n > -1) {
                object = this.get_member_obj;
                string2 = string2.substring(n + 1);
                Main.debug("callMember basename: " + string2);
            } else {
                object = kJASAppletStub.getApplet();
            }
            Class<?> clazz = object.getClass();
            Class[] classArray = new Class[list.size()];
            int n2 = 0;
            while (n2 < list.size()) {
                classArray[n2] = string2.getClass();
                ++n2;
            }
            Method method = this.findMethod(clazz, string2, classArray);
            Object[] objectArray = new Object[list.size()];
            int n3 = 0;
            while (n3 < list.size()) {
                objectArray[n3] = list.get(n3);
                ++n3;
            }
            String string3 = method.getReturnType().getName();
            Object object2 = method.invoke(object, objectArray);
            if (object2 == null) {
                return 6;
            }
            stringBuffer.insert(0, object2.toString());
            Main.debug("Call value of object: " + stringBuffer + " " + string3);
            if (string3.equals("boolean") || string3.equals("java.lang.Boolean")) {
                return 1;
            }
            if (string3.equals("int") || string3.equals("java.lang.Integer")) {
                return 3;
            }
            return 5;
        }
        catch (Exception exception) {
            Main.debug("callMember throwed exception: " + exception.toString());
            exception.printStackTrace();
            return 0;
        }
    }

    public void setStream(String string, InputStream inputStream) throws IOException {
        Main.debug("setStream, key = " + string);
        this.streams.put(string, inputStream);
    }

    public InputStream getStream(String string) {
        Main.debug("getStream, key = " + string);
        return (InputStream)this.streams.get(string);
    }

    public Iterator getStreamKeys() {
        Main.debug("getStreamKeys");
        return this.streams.keySet().iterator();
    }
}

