/***************************************************************************
                          move.cpp  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "move.h"

Move::Move(): GeoPoint()
{
	identificator = "Move";
	ID = ID_move;

	int temp[] = { ID_geoPoint, 1, ID_vector, 1, -1 };
	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
}

Move::~Move()
{
}

void Move::move()
{
	if ( isTrace )
	{
		trace.append( new QRect( surroundingRect ) );
	}

	int indexPoint = 0;
	int indexVector = 1;

	if ( parents.at( 0 )->identify() == "Vector" )
	{
  	indexPoint = 1;
  	indexVector = 0;
	}

	Coordinates coord1, coord2, coord3;
	coord1 = parents.at( indexVector )->getStartCoordinates();	
	coord2 = parents.at( indexVector )->getEndCoordinates();	
	coord3 = parents.at( indexPoint )->getCoordinates();

	coords = coord2 - coord1;
	coords += coord3;

	//	Calculate new rectangle around point.
	if ( ( size % 2 ) == 0 )
		size += 1;

	int x = coords.getI_X() - ( ( size - 1 ) / 2 );
	int y = coords.getI_Y() - ( ( size - 1 ) / 2 );

	//  Set rectangle.
	surroundingRect = QRect ( x ,y ,size ,size );
}

