/***************************************************************************
                            KHelpMenu.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KHELPMENU_H
#define KHELPMENU_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 This class provides the standard KDE help menu with the default "about"
 dialog boxes and help entry.

 This class is used in @ref KMainWindow so
 normally you don't need to use this class yourself. However, if you
 need the help menu or any of its dialog boxes in your code that is
 not subclassed from @ref KMainWindow you should use this class.

 The usage is simple:

 <pre>
 mHelpMenu = new KHelpMenu( this, <someText> );
 -[kmenubar insertItem](i18n("&Help"), -[mHelpMenu menu] );
 </pre>

 or if you just want to open a dialog box:

 <pre>
 mHelpMenu = new KHelpMenu( this, <someText> );
 connect( this, SIGNAL(-someSignal), mHelpMenu,SLOT(-[mHelpMenu aboutKDE]));
 </pre>

 IMPORTANT:
 The first time you use @ref -[KHelpMenu menu], a @ref KPopupMenu object is
 allocated. Only one object is created by the class so if you call
 @ref -[KHelpMenu menu] twice or more, the same pointer is returned. The class
 will destroy the popupmenu in the destructor so do not delete this
 pointer yourself.

 The KHelpMenu object will be deleted when its parent is destroyed but you
 can delete it yourself if you want. The code below will always work.

 <pre>
 MyClass::~-MyClass
 {
   delete mHelpMenu;
 }
 </pre>

 Using your own "about application" dialog box:

 The standard "about application" dialog box is quite simple. If you
 need a dialog box with more functionality you must design that one
 yourself. When you want to display the dialog you can choose one of
 two methods. Common for both is that you must make a help menu object
 with no text argument If the text is missing the default dialog box
 will not be displayed:

 Example 1 Using @ref showAboutApplication signal (preferred)
 <pre>

 void -[MyClass myFunc]
 {
   ..
   KHelpMenu *helpMenu = new KHelpMenu( this );
   connect( helpMenu, SIGNAL(-showAboutApplication),
          this, SLOT(-myDialogSlot));
   ..
 }

 void -[MyClass myDialogSlot]
 {
   <activate your custom dialog>
 }
 </pre>

 Example 2 Old style - connecting directly to the menu entry.
 <pre>

 void -[MyClass myFunc]
 {
   KHelpMenu *helpMenu = new KHelpMenu( this );
   KPopupMenu *help = -[mHelpMenu menu];
   -[help connectItem]( -[KHelpMenu menuAboutApp], this, SLOT(-myDialogSlot) );
 }

 void -[MyClass myDialogSlot]
 {
   <activate your custom dialog>
 }
 </pre>

 @author Espen Sand (espen@kde.org)

 @version $Id: KHelpMenu.h,v 1.3 2002/03/15 02:12:20 rdale Exp $
 
 @short Standard KDE help menu with dialog boxes.

*/
@class KAboutData; 
@class KPopupMenu;
@class KActionCollection;

@interface KHelpMenu : QObject 

/** 
 Constructor.

     
*/
- initWithWidget: (QWidget *)parent aboutAppText: (NSString *)aboutAppText showWhatsThis: (BOOL)showWhatsThis;
- init;

/** 
 Constructor.

     
*/
- initWithWidget: (QWidget *)parent aboutData: (KAboutData*)aboutData showWhatsThis: (BOOL)showWhatsThis actions: (KActionCollection*)actions;
- initWithWidget: (QWidget *)parent aboutData: (KAboutData*)aboutData ;

/** 
 Destructor

 Destroys dialogs and the menu pointer retuned by @ref menu
     
*/
- (void) dealloc;

/** 
 Returns a popup menu you can use in the menu bar or where you
 need it.

 Note: This method will only create one instance of the menu. If
 you call this method twice or more the same pointer is returned
     
*/
- (KPopupMenu*) menu;

/** 
 Opens the help page for the application. The application name is
 used as a key to determine what to display and the system will attempt
 to open <appName>/index.html.
     
*/
- appHelpActivated;

/** 
 Activates What's This help for the application.
     
*/
- contextHelpActivated;

/** 
 Opens an application specific dialog box. The dialog box will display
 the string that was defined in the constructor. If that string was
 empty the @ref -showAboutApplication is emitted instead.
     
*/
- aboutApplication;

/** 
 Opens the standard "About KDE" dialog box.
     
*/
- aboutKDE;

/** 
 Opens the standard "Report Bugs" dialog box.
     
*/
- reportBug;
+ (int) menuHelpContents;
+ (int) menuWhatsThis;
+ (int) menuAboutApp;
+ (int) menuAboutKDE;
+ (int) menuReportBug;
@end

/** Override these methods in subclasses of KHelpMenu to customise event handling behaviour */
@protocol KHelpMenuEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
