/***************************************************************************
                            KAnimWidget.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KANIMWIDGET_H
#define KANIMWIDGET_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QFrame.h>

/**

 This is a widget used to display animation using multiple
 individual pixmaps.  This widget allows you to deal with variable
 size icons (e.g., ones that will change based on a global setting)
 as it loads the icons internally.  All you need to do is pass along
 a list of icon names and their size and everything else is taken
 care of.

 This widget also emits a '-clicked' signal when it received a
 mouse press event.

 A quick example:
 <pre>
 QStringList icons;
 icons.append("one");
 icons.append("two");
 icons.append("three");
 KAnimWidget *anim = new KAnimWidget(icons, 0, this);
 -[anim start];
 </pre>

 That example will search for the pixmaps "one.png", "two.png", and
 "three.png" in the share/icons/small/ directories as well as the
 app's pics directory.

 @author Kurt Granroth <granroth@kde.org>
 
 @short Widget animated using individual icons.
*/
@interface KAnimWidget : QFrame 

/** 
 This is the most common constructor.  Pass along the name of the
 animated icons to use (e.g., "kde") for the animation and an
 optional size to load and you're set.  If you omit the size, the
 default size will be used.

*/
- initWithText: (NSString *)icons size: (int)size parent: (QWidget *)parent name: (NSString *)name;
- initWithText: (NSString *)icons ;

/** 
 Default constructor.  This will not do anything until you use
 @ref -setIcons later.

*/
//- initWithWidget: (QWidget *)parent name: (NSString *)name;
//- init;

/** 
 Destructor
   
*/
- (void) dealloc;

/** 
 Starts the animation from frame 1
   
*/
- start;

/** 
 Stops the animation.  This will also reset the widget to frame 1.
   
*/
- stop;

/** 
 Sets the size of the icons.

*/
- setSize: (int)size;

/** 
 Sets the name of the animated icons to load.  This will use the
 -[KIconLoader loadAnimated]method for the actual loading.

*/
- setIcons: (NSString *)icons;
- drawContents: (QPainter *)p;
- slotTimerUpdate;
- updateIcons;
@end

/** Override these methods in subclasses of KAnimWidget to customise event handling behaviour */
@protocol KAnimWidgetEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) e;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) e;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) e;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) e;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) e;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
