/***************************************************************************
                            KIconTheme.java -  description
                             -------------------
    begin                : Tue Jan 29 14:50:06 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Tue Jan 29 14:50:06 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Class to use/access icon themes in KDE. This class is used by the
 iconloader but can be used by others too.
 
 @short 
 Class to use/access icon themes in KDE.
*/
public class  KIconTheme implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KIconTheme(Class dummy){}

	private native void newKIconTheme( String name, String appName);

/**  Load an icon theme by name.  
*/
	public KIconTheme( String name, String appName) {
		newKIconTheme( name, appName);
	}
	private native void newKIconTheme( String name);
	public KIconTheme( String name) {
		newKIconTheme( name);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/**  The stylized name of the icon theme. 
*/
	public native String name();

/**  A description for the icon theme. 
*/
	public native String description();

/**  Return the name of the "example" icon. 
*/
	public native String example();

/**  Return the name of the screenshot. 
*/
	public native String screenshot();

/**  Returns the name of this theme's link overlay. 
*/
	public native String linkOverlay();

/**  Returns the name of this theme's zip overlay. 
*/
	public native String zipOverlay();

/**  Returns the name of this theme's lock overlay. 
*/
	public native String lockOverlay();

/**  Returns the toplevel theme directory. 
*/
	public native String dir();

/**  The themes this icon theme falls back on. 
*/
	public native ArrayList inherits();

/**  The icon theme exists? 
*/
	public native boolean isValid();

/**  The minimum display depth required for this theme. This can either
 be 8 or 32 
*/
	public native int depth();

/**  The default size of this theme for a certain icon group.

*/
	public native int defaultSize( int group);

/**  Query available sizes for a group. 
*/
	public native int[] querySizes( int group);

/**  Query available icons for a size and context. 
*/
	public native ArrayList queryIcons( int size, int context);

/**  Query available icons for a context and preferred size. 
*/
	public native ArrayList queryIconsByContext( int size, int context);

/**  Lookup an icon in the theme.

*/
	public native KIcon iconPath( String name, int size, int match);

/**  List all icon themes installed on the system, global and local. 
*/
	public static native ArrayList list();

/**  Returns the current icon theme. 
*/
	public static native String current();
	public static native void reconfigure();
}
