/***************************************************************************
                            KFileItem.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A KFileItem is a generic class to handle a file, local or remote.
 In particular, it makes it easier to handle the result of KIO.listDir.
 (UDSEntry isn't very friendly to use)
 It includes many file attributes such as mimetype, icon, text, mode, link...
 
 @short 
 A KFileItem is a generic class to handle a file, local or remote.
*/
public class  KFileItem implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KFileItem(Class dummy){}

//	private native void newKFileItem( UDSEntry _entry, KURL _url, boolean _determineMimeTypeOnDemand, boolean _urlIsDirectory);

/** 
 Creates an item representing a file, from a {@link UDSEntry}.
 This is the preferred constructor when using KIO.listDir().

*/
//	public KFileItem( UDSEntry _entry, KURL _url, boolean _determineMimeTypeOnDemand, boolean _urlIsDirectory) {
//		newKFileItem( _entry, _url, _determineMimeTypeOnDemand, _urlIsDirectory);
//	}
//	private native void newKFileItem( UDSEntry _entry, KURL _url);
//	public KFileItem( UDSEntry _entry, KURL _url) {
//		newKFileItem( _entry, _url);
//	}
	private native void newKFileItem( long _mode, long _permissions, KURL _url, boolean _determineMimeTypeOnDemand);

/** 
 Creates an item representing a file, from all the necessary info for it.

*/
	public KFileItem( long _mode, long _permissions, KURL _url, boolean _determineMimeTypeOnDemand) {
		newKFileItem( _mode, _permissions, _url, _determineMimeTypeOnDemand);
	}
	private native void newKFileItem( long _mode, long _permissions, KURL _url);
	public KFileItem( long _mode, long _permissions, KURL _url) {
		newKFileItem( _mode, _permissions, _url);
	}
	private native void newKFileItem( KURL url, String mimeType, long mode);

/** 
 Creates an item representing a file, for which the mimetype is already known.

*/
	public KFileItem( KURL url, String mimeType, long mode) {
		newKFileItem( url, mimeType, mode);
	}
	private native void newKFileItem( KFileItem item);

/** 
 Copy constructor. Note that extra-data set via {@link #setExtraData} is not
 deeply copied -- just the pointers are copied.
   
*/
	public KFileItem( KFileItem item) {
		newKFileItem( item);
	}

/** 
 Destructs the KFileItem. Extra data set via setExtraData()
 is not deleted.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Re-reads information (currently only permissions and mimetype).
 This is called when the _file_ changes.
   
*/
	public native void refresh();

/** 
 Re-reads mimetype information.
 This is called when the mimetype database changes.
   
*/
	public native void refreshMimeType();

/** 
 Returns the url of the file.
   
*/
	public native KURL url();

/** 
 Sets the item's URL. Do not call unless you know what you are doing!
 (used for example when an item got renamed).
   
*/
	public native void setURL( KURL url);

/** 
 Returns the permissions of the file (stat.st_mode containing only permissions).
   
*/
	public native long permissions();

/** 
 Returns the access permissions for the file as a string.
   
*/
	public native String permissionsString();

/** 
 Returns the file type (stat.st_mode containing only S_IFDIR, S_IFLNK, ...).
   
*/
	public native long mode();

/** 
 Returns the owner of the file.
   
*/
	public native String user();

/** 
 Returns the group of the file.
   
*/
	public native String group();

/** 
 Returns true if this item represents a link in the UNIX sense of
 a link.
   
*/
	public native boolean isLink();

/** 
 Returns true if this item represents a directory.
   
*/
	public native boolean isDir();

/** 
 Returns true if this item represents a file (and not a a directory)
   
*/
	public native boolean isFile();

/** 

*/
	public native boolean isReadable();

/** 
 Returns the link destination if isLink() == true.
   
*/
	public native String linkDest();

/** 
 Returns the size of the file, if known.
   
*/
	public native int size();

/** 

*/
	public native long time( int which);

/** 

*/
	public native String timeString( int which);
	public native String timeString();

/** 
 Returns true if the file is a local file.
   
*/
	public native boolean isLocalFile();

/** 
 Returns the text of the file item.
 It's not exactly the filename since some decoding happens ('%2F'.'/').
   
*/
	public native String text();

/** 

*/
	public native String name( boolean lowerCase);
	public native String name();

/** 
 Returns the mimetype of the file item.
   
*/
	public native String mimetype();

/** 
 Returns the mimetype of the file item.
 If determineMimeTypeOnDemand was used, this will determine the mimetype first.
   
*/
//	public native KMimeType_Ptr determineMimeType();

/** 
 Returns the currently known mimetype of the file item.
 This will not try to determine the mimetype if unknown.
   
*/
//	public native KMimeType_Ptr mimeTypePtr();
	public native boolean isMimeTypeKnown();

/** 
 Returns the descriptive comment for this mime type, or
 the mime type itself if none is present.
   
*/
	public native String mimeComment();

/** 
 Returns the full path name to the icon that represents
 this mime type.
   
*/
	public native String iconName();

/** 
 Returns a pixmap representing the file.

*/
	public native QPixmap pixmap( int _size, int _state);
	public native QPixmap pixmap( int _size);

/** 
 Returns the string to be displayed in the statusbar,
 e.g. when the mouse is over this item
   
*/
	public native String getStatusBarInfo();

/** 

*/
	public native String getToolTipText( int maxcount);
	public native String getToolTipText();

/** 
 Returns true if files can be dropped over this item.
 Contrary to popular belief, not only dirs will return true :)
 Executables, .desktop files, will do so as well.
   
*/
	public native boolean acceptsDrops();

/** 
 Let's "KRun" this file !
 (e.g. when file is clicked or double-clicked or return is pressed)
   
*/
	public native void run();

/** 
 Returns the UDS entry. Used by the tree view to access all details
 by position.
   
*/
//	public native UDSEntry entry();
	public native boolean isMarked();
	public native void mark();
	public native void unmark();

/** 
 Somewhat like a comparison operator, but more explicit
   
*/
	public native boolean cmp( KFileItem item);

/** 
 This allows to associate some "extra" data to a KFileItem. As one
 KFileItem can be used by several objects (often views) which all need
 to add some data, you have to use a key to reference your extra data
 within the KFileItem.

 That way a KFileItem can hold and provide access to all those views
 separately.

 I.e. a KFileIconView that associates a KFileIconViewItem (an item suitable
 for use with QIconView) does

 <pre>
 kfileItem.setExtraData( this, iconViewItem );
 </pre>

 and can later access the iconViewItem by doing

 <pre>
 KFileIconViewItem iconViewItem = static_cast<KFileIconViewItem>( kfileItem.extraData( this ));
 </pre>

 This is usually more efficient then having every view associate data to
 items by using a separate QDict or QMap.

 Note: you have to remove and destroy the data you associated yourself
 when you don't need it anymore!

*/
	public native void setExtraData( int key, int value);

/** 

*/
	public native int extraData( int key);

/** 
 The non-const version of the previous <code>extraData</code>() method.
   
*/
//	public native int extraData( int key);

/** 
 Removes the extra data associated with an item via <code>key.</code>
   
*/
	public native void removeExtraData( int key);
//	public native void setMetaInfo( KFileMetaInfo* info);
//	public native KFileMetaInfo& metaInfo();

/** 
 Somewhat like an assignment operator, but more explicit.
 Note: extra-data set with {@link #setExtraData} is not copied, so be careful
 what you do!

 I.e. KDirLister uses it to update existing items from a fresh item.
   
*/
	public native void assign( KFileItem item);

/** 
 Computes the text, mode, and mimetype from the UDSEntry
 Called by constructor, but can be called again later
   
*/
	protected native void init( boolean _determineMimeTypeOnDemand);

/** 
 Parses the given permission set and provides it for {@link #access}
   
*/
	protected native String parsePermissions( long perm);
//	public static final int Unknown = (mode_t)-1;
}
