/***************************************************************************
                            KCompletion.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class offers easy use of "auto-completion", "manual-completion" or
 "shell completion" on String objects. A common use is completing filenames
 or URLs (see {@link #KURLCompletion}).
 But it is not limited to URL-completion -- everything should be completable!
 The user should be able to complete email-addresses, telephone-numbers,
 commands, SQL queries, ...
 Every time your program knows what the user can type into an edit-field, you
 should offer completion. With KCompletion, this is very easy, and if you are
 using a line edit widget ({@link KLineEdit}), it is even more easy.
 Basically, you tell a KCompletion object what strings should be completable
 and whenever completion should be invoked, you call {@link #makeCompletion}.
 KLineEdit and (an editable) KComboBox even do this automatically for you.

 KCompletion offers the completed string via the signal {@link #match} and
 all matching strings (when the result is ambiguous) via the method
 {@link #allMatches}.

 Notice: auto-completion, shell completion and manual completion work
         slightly differently:

 You don't have to worry much about that though, KCompletion handles
 that for you, according to the setting {@link #setCompletionMode}.
 The default setting is globally configured by the user and read
 from {@link KGlobalSettings#completionMode}.

 A short example:
 <pre>
 KCompletion completion;
 completion.setOrder( KCompletion.Sorted );
 completion.addItem( "pfeiffer@kde.org" );
 completion.addItem( "coolo@kde.org" );
 completion.addItem( "carpdjih@sp.zrz.tu-berlin.de" );
 completion.addItem( "carp@cs.tu-berlin.de" );

 cout << completion.makeCompletion( "ca" ).latin1() << endl;
 </pre>
 In shell-completion-mode, this will be "carp"; in auto-completion-
 mode it will be "carp@cs.tu-berlin.de", as that is alphabetically
 smaller.
 If setOrder was set to Insertion, "carpdjih@sp.zrz.tu-berlin.de"
 would be completed in auto-completion-mode, as that was inserted before
 "carp@cs.tu-berlin.de".

 You can dynamically update the completable items by removing and adding them
 whenever you want.
 For advanced usage, you could even use multiple KCompletion objects. E.g.
 imagine an editor like kwrite with multiple open files. You could store
 items of each file in a different KCompletion object, so that you know (and
 tell the user) where a completion comes from.

 Note: KCompletion does not work with strings that contain 0x0 characters
       (unicode nul), as this is used internally as a delimiter.

 You may inherit from KCompletion and override {@link #makeCompletion} in
 special cases (like reading directories/urls and then supplying the
 contents to KCompletion, as KURLCompletion does), but generally, this is
 not necessary.

 See {@link KCompletionSignals} for signals emitted by KCompletion.

 See {@link KCompletionEventHandling} for event handlers to override in subclasses of KCompletion.

 @author Carsten Pfeiffer <pfeiffer@kde.org>

 @version $Id: KCompletion.java,v 1.6 2002/01/31 04:48:56 rdale Exp $
 
 @short A generic class for completing QStrings.
*/
public class KCompletion extends QObject  {
	protected KCompletion(Class dummy){super((Class) null);}

	private native void newKCompletion();

/** 
 Constructor, nothing special here :)
     
*/
	public KCompletion() {
		super((Class) null);
		newKCompletion();
	}

/** 
 Destructor, nothing special here, either.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Attempts to find an item in the list of available completions,
 that begins with <code>string.</code> Will either return the first matching item
 (if there is more than one match) or String.null, if no match was
 found.

 In the latter case, a sound will be issued, depending on
 {@link #isSoundsEnabled}.
 If a match was found, it will also be emitted via the signal
 {@link #match}.

 If this is called twice or more often with the same string while no
 items were added or removed in the meantime, all available completions
 will be emitted via the signal {@link #matches}.
 This happens only in shell-completion-mode.

*/
	public native String makeCompletion( String string);

/** 

*/
	public native ArrayList substringCompletion( String string);

/** 

*/
	public native String previousMatch();

/** 

*/
	public native String nextMatch();

/** 

*/
	public native String lastMatch();

/** 
 Returns a list of all items inserted into KCompletion. This is useful
 if you need to save the state of a KCompletion object and restore it
 later.

 Important note: when {@link #order} == Weighted, then every item in the
 stringlist has its weight appended, delimited by a colon. E.g. an item
 "www.kde.org" might look like "www.kde.org:4", where 4 is the weight.

 This is necessary so that you can save the items along with its
 weighting on disk and load them back with {@link #setItems}, restoring its
 weight as well. If you really don't want the appended weightings, call
 {@link #setOrder}
 before calling items().

*/
	public native ArrayList items();

/** 
 Sets the completion mode to Auto/Manual, Shell or None.
 If you don't set the mode explicitly, the global default value
 KGlobalSettings.completionMode() is used.
 {@link KGlobalSettings#CompletionNone} disables completion.

*/
	public native void setCompletionMode( int mode);

/** 

*/
	public native int completionMode();

/** 
 KCompletion offers three different ways in which it offers its items:

 Choosing weighted makes KCompletion perform an implicit weighting based
 on how often an item is inserted. Imagine a web browser with a location
 bar, where the user enters URLs. The more often a URL is entered, the
 higher priority it gets.

 Note: Setting the order to sorted only affects new inserted items,
 already existing items will stay in the current order. So you probably
 want to call setOrder( Sorted ) before inserting items, when you want
 everything sorted.

 Default is insertion order

*/
	public native void setOrder( int order);

/** 

*/
	public native int order();

/** 
 Setting this to true makes KCompletion behave case insensitively.
 E.g. makeCompletion( "CA" ); might return "carp@cs.tu-berlin.de".
 Default is false (case sensitive).

*/
	public native void setIgnoreCase( boolean ignoreCase);

/** 

*/
	public native boolean ignoreCase();

/** 

*/
	public native ArrayList allMatches();

/** 

*/
	public native ArrayList allMatches( String string);

/** 

*/
//	public native KCompletionMatches allWeightedMatches();

/** 

*/
//	public native KCompletionMatches allWeightedMatches( String string);

/** 
 Enables/disables playing a sound when

 For playing the sounds, {@link #KNotifyClient} is used.

*/
	public native void setEnableSounds( boolean enable);

/** 
 Tells you whether KCompletion will play sounds on certain occasions.
 Default is enabled

*/
	public native boolean isSoundsEnabled();

/** 

*/
	public native boolean hasMultipleMatches();

/** 

*/
	public native void enableSounds();

/** 

*/
	public native void disableSounds();

/** 
 Attempts to complete "string" and emits the completion via {@link #match}.
 Same as {@link #makeCompletion} (just as a slot).

*/
	public native void slotMakeCompletion( String string);

/** 
 Searches the previous matching item and emits it via {@link #match}
 Same as {@link #previousMatch} (just as a slot).

*/
	public native void slotPreviousMatch();

/** 
 Searches the next matching item and emits it via {@link #match}
 Same as {@link #nextMatch} (just as a slot).

*/
	public native void slotNextMatch();

/** 
 Inserts <code>items</code> into the list of possible completions.
 Does the same as {@link #setItems}, but does not call {@link #clear} before.
     
*/
	public native void insertItems( String[] items);

/** 
 Sets the list of items available for completion. Removes all previous
 items.

 Notice: when order() == Weighted, then the weighting is looked up for
 every item in the stringlist. Every item should have ":number" appended,
 where number is an unsigned integer, specifying the weighting.

 If you don't like this, call
 setOrder( KCompletion.Insertion )
 before calling setItems().

*/
	public native void setItems( String[] arg1);

/** 
 Adds an item to the list of available completions.
 Resets the current item-state ({@link #previousMatch} and {@link #nextMatch}
 won't work anymore).
     
*/
	public native void addItem( String arg1);

/** 
 Adds an item to the list of available completions.
 Resets the current item-state ({@link #previousMatch} and {@link #nextMatch}
 won't work anymore).

 Sets the weighting of the item to <code>weight</code> or adds it to the current
 weighting if the item is already available. The weight has to be greater
 than 1 to take effect (default weight is 1).
     
*/
	public native void addItem( String arg1, int weight);

/** 
 Removes an item from the list of available completions.
 Resets the current item-state ({@link #previousMatch} and {@link #nextMatch}
 won't work anymore).
     
*/
	public native void removeItem( String arg1);

/** 
 Removes all inserted items.
     
*/
	public native void clear();

/** 
 This method is called after a completion is found and before the
 matching string is emitted. You can override this method to modify the
 string that will be emitted.
 This is necessary e.g. in {@link #KURLCompletion}, where files with spaces
 in their names are shown escaped ("filename\ with\ spaces"), but stored
 unescaped inside KCompletion.
 Never delete that pointer!

 Default implementation does nothing.

*/
	protected native void postProcessMatch( String arg1);

/** 
 This method is called before a list of all available completions is
 emitted via {@link matches}. You can override this method to modify the
 found items before {@link #match} or {@link #matches} are emitted.
 Never delete that pointer!

 Default implementation does nothing.

*/
	protected native void postProcessMatches( String[] arg1);

/** 
 This method is called before a list of all available completions is
 emitted via {@link matches}. You can override this method to modify the
 found items before {@link #match} or {@link #matches} are emitted.
 Never delete that pointer!

 Default implementation does nothing.

*/
//	protected native void postProcessMatches( KCompletionMatches* arg1);
	public static final int Sorted = 0;
	public static final int Insertion = 1;
	public static final int Weighted = 2;
}
