/***************************************************************************
                            kde_KStdAccel.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSTDACCEL
#define KDE_KSTDACCEL

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Convenient methods for access to the common accelerator keys in
 the key configuration. These are the standard keybindings that should
 be used in all KDE applications. They will be configurable,
 so do not hardcode the default behavior.

 If you want real configurable keybindings in your applications,
 please checkout the class @ref KAccel in kaccel.h
 
 @short 
 Convenient methods for access to the common accelerator keys in
 the key configuration.
*/
#define KSTDACCEL_AccelNone	0
#define KSTDACCEL_Open	1
#define KSTDACCEL_New	2
#define KSTDACCEL_Close	3
#define KSTDACCEL_Save	4
#define KSTDACCEL_Print	5
#define KSTDACCEL_Quit	6
#define KSTDACCEL_Undo	7
#define KSTDACCEL_Redo	8
#define KSTDACCEL_Cut	9
#define KSTDACCEL_Copy	10
#define KSTDACCEL_Paste	11
#define KSTDACCEL_SelectAll	12
#define KSTDACCEL_Deselect	13
#define KSTDACCEL_DeleteWordBack	14
#define KSTDACCEL_DeleteWordForward	15
#define KSTDACCEL_Find	16
#define KSTDACCEL_FindNext	17
#define KSTDACCEL_FindPrev	18
#define KSTDACCEL_Replace	19
#define KSTDACCEL_Home	20
#define KSTDACCEL_End	21
#define KSTDACCEL_Prior	22
#define KSTDACCEL_Next	23
#define KSTDACCEL_GotoLine	24
#define KSTDACCEL_AddBookmark	25
#define KSTDACCEL_ZoomIn	26
#define KSTDACCEL_ZoomOut	27
#define KSTDACCEL_Up	28
#define KSTDACCEL_Back	29
#define KSTDACCEL_Forward	30
#define KSTDACCEL_Reload	31
#define KSTDACCEL_PopupMenuContext	32
#define KSTDACCEL_ShowMenubar	33
#define KSTDACCEL_Help	34
#define KSTDACCEL_WhatsThis	35
#define KSTDACCEL_TextCompletion	36
#define KSTDACCEL_PrevCompletion	37
#define KSTDACCEL_NextCompletion	38
#define KSTDACCEL_SubstringCompletion	39
#define KSTDACCEL_RotateUp	40
#define KSTDACCEL_RotateDown	41
#define KSTDACCEL_WhatThis	KSTDACCEL_WhatsThis

/**  Returns the keybinding for @p accel. 
*/
kde_KShortcut* kde_KStdAccel_shortcut(int identifier);

/**  Returns a unique name for the given @p accel. 
*/
qt_QString * kde_KStdAccel_name(int identifier);

/**  Returns a localized label for user-visible display. 
*/
qt_QString * kde_KStdAccel_label(int identifier);

/**  Returns an extended WhatsThis description for the given accelerator. 
*/
qt_QString * kde_KStdAccel_whatsThis(int identifier);

/** 
 Returns the hardcoded default shortcut for @p id.
 This does not take into account the user's configuration.
   
*/
kde_KShortcut* kde_KStdAccel_shortcutDefault(int identifier);

/** 
 Returns the hardcoded default 3 modifier shortcut for @p id.
 This does not take into account the user's configuration.
   
*/
kde_KShortcut* kde_KStdAccel_shortcutDefault3(int identifier);

/** 
 Returns the hardcoded default 4 modifier shortcut for @p id.
 This does not take into account the user's configuration.
   
*/
kde_KShortcut* kde_KStdAccel_shortcutDefault4(int identifier);
void kde_KStdAccel_createAccelActions(kde_KAccelActions* arg1);

/**  Open file. Default: Ctrl-o 
*/
kde_KShortcut* kde_KStdAccel_open(kde_KStdAccel* instPointer);

/**  Create a new document (or whatever). Default: Ctrl-n 
*/
kde_KShortcut* kde_KStdAccel_openNew(kde_KStdAccel* instPointer);

/**  Close current document. Default: Ctrl-w 
*/
kde_KShortcut* kde_KStdAccel_close(kde_KStdAccel* instPointer);

/**  Save current document. Default: Ctrl-s 
*/
kde_KShortcut* kde_KStdAccel_save(kde_KStdAccel* instPointer);

/**  Print current document. Default: Ctrl-p 
*/
kde_KShortcut* kde_KStdAccel_print(kde_KStdAccel* instPointer);

/**  Quit the program. Default: Ctrl-q 
*/
kde_KShortcut* kde_KStdAccel_quit(kde_KStdAccel* instPointer);

/**  Undo last operation. Default: Ctrl-z 
*/
kde_KShortcut* kde_KStdAccel_undo(kde_KStdAccel* instPointer);

/**  Redo. Default: Shift-Ctrl-z 
*/
kde_KShortcut* kde_KStdAccel_redo(kde_KStdAccel* instPointer);

/**  Cut selected area and store it in the clipboard. Default: Ctrl-x 
*/
kde_KShortcut* kde_KStdAccel_cut(kde_KStdAccel* instPointer);

/**  Copy selected area into the clipboard. Default: Ctrl-c 
*/
kde_KShortcut* kde_KStdAccel_copy(kde_KStdAccel* instPointer);

/**  Paste contents of clipboard at mouse/cursor position. Default: Ctrl-v 
*/
kde_KShortcut* kde_KStdAccel_paste(kde_KStdAccel* instPointer);

/**  Reload. Default: Ctrl-A *
*/
kde_KShortcut* kde_KStdAccel_selectAll(kde_KStdAccel* instPointer);

/**  Delete a word back from mouse/cursor position. Default: Ctrl-Backspace 
*/
kde_KShortcut* kde_KStdAccel_deleteWordBack(kde_KStdAccel* instPointer);

/**  Delete a word forward from mouse/cursor position. Default: Ctrl-Delete 
*/
kde_KShortcut* kde_KStdAccel_deleteWordForward(kde_KStdAccel* instPointer);

/**  Find, search. Default: Ctrl-f 
*/
kde_KShortcut* kde_KStdAccel_find(kde_KStdAccel* instPointer);

/**  Find/search next. Default: F3 
*/
kde_KShortcut* kde_KStdAccel_findNext(kde_KStdAccel* instPointer);

/**  Find/search previous. Default: Shift-F3 
*/
kde_KShortcut* kde_KStdAccel_findPrev(kde_KStdAccel* instPointer);

/**  Find and replace matches. Default: Ctrl-r 
*/
kde_KShortcut* kde_KStdAccel_replace(kde_KStdAccel* instPointer);

/**  Zoom in. Default: Ctrl-Plus 
*/
kde_KShortcut* kde_KStdAccel_zoomIn(kde_KStdAccel* instPointer);

/**  Zoom out. Default: Ctrl-Minus 
*/
kde_KShortcut* kde_KStdAccel_zoomOut(kde_KStdAccel* instPointer);

/**  Toggle insert/overwrite (with visual feedback, e.g. in the statusbar). Default: Insert 
*/
kde_KShortcut* kde_KStdAccel_insert(kde_KStdAccel* instPointer);

/**  Goto beginning of current line. Default: Home 
*/
kde_KShortcut* kde_KStdAccel_home(kde_KStdAccel* instPointer);

/**  Goto end of current line. Default: End 
*/
kde_KShortcut* kde_KStdAccel_end(kde_KStdAccel* instPointer);

/**  Scroll up one page. Default: Prior 
*/
kde_KShortcut* kde_KStdAccel_prior(kde_KStdAccel* instPointer);

/**  Scroll down one page. Default: Next 
*/
kde_KShortcut* kde_KStdAccel_next(kde_KStdAccel* instPointer);

/**  Go to line. Default: Ctrl+G 
*/
kde_KShortcut* kde_KStdAccel_gotoLine(kde_KStdAccel* instPointer);

/**  Add current page to bookmarks. Default: Ctrl+B 
*/
kde_KShortcut* kde_KStdAccel_addBookmark(kde_KStdAccel* instPointer);

/**  Help the user in the current situation. Default: F1 
*/
kde_KShortcut* kde_KStdAccel_help(kde_KStdAccel* instPointer);

/**  Complete text in input widgets. Default Ctrl+E *
*/
kde_KShortcut* kde_KStdAccel_completion(kde_KStdAccel* instPointer);

/**  Iterate through a list when completion returns
      mutiple items. Default: Ctrl+Up *
*/
kde_KShortcut* kde_KStdAccel_prevCompletion(kde_KStdAccel* instPointer);

/**  Iterate through a list when completion returns
      mutiple items. Default: Ctrl+Down *
*/
kde_KShortcut* kde_KStdAccel_nextCompletion(kde_KStdAccel* instPointer);

/**  Find a string within another string or list of strings.
      Default: Ctrl-T 
*/
kde_KShortcut* kde_KStdAccel_substringCompletion(kde_KStdAccel* instPointer);

/**  Help users iterate through a list of entries. Default: Up *
*/
kde_KShortcut* kde_KStdAccel_rotateUp(kde_KStdAccel* instPointer);

/**  Help users iterate through a list of entries. Default: Down *
*/
kde_KShortcut* kde_KStdAccel_rotateDown(kde_KStdAccel* instPointer);

/**  popup a context menu. Default: Menu *
*/
kde_KShortcut* kde_KStdAccel_popupMenuContext(kde_KStdAccel* instPointer);

/**  What's This button. Default: Shift+F1 *
*/
kde_KShortcut* kde_KStdAccel_whatsThis1(kde_KStdAccel* instPointer);

/**  Reload. Default: F5 *
*/
kde_KShortcut* kde_KStdAccel_reload(kde_KStdAccel* instPointer);

/**  Up. Default: Alt+Up *
*/
kde_KShortcut* kde_KStdAccel_up(kde_KStdAccel* instPointer);

/**  Back. Default: Alt+Left *
*/
kde_KShortcut* kde_KStdAccel_back(kde_KStdAccel* instPointer);

/**  Forward. Default: ALT+Right *
*/
kde_KShortcut* kde_KStdAccel_forward(kde_KStdAccel* instPointer);

/**  Show Menu Bar.  Default: Ctrl-M *
*/
kde_KShortcut* kde_KStdAccel_showMenubar(kde_KStdAccel* instPointer);

/**  Obsolete.  Use name().  Returns a string representation for @p accel. 
*/
qt_QString * kde_KStdAccel_action(int identifier);

/**  Obsolete.  Use desc().  Returns a localized description of @p accel. 
*/
qt_QString * kde_KStdAccel_description(int identifier);

/**  Obsolete.  Use shortcut().  Returns the keybinding for @p accel. 
*/
int kde_KStdAccel_key(int arg1);

/**  Obsolete.  Use shortcutDefault(). 
*/
int kde_KStdAccel_defaultKey(int accel);

/** 
 @depricated.  Use KKey(const QKeyEvent*) == KKey(int).

 Compare the keys generated by the key event with
 the value of the integer.

 If a modifier (Shift, Alt, Ctrl) key is present in
 @ref QKeyEvent, its sum with the actual key value
 is used for comparing it with the integer parameter.

*/
int kde_KStdAccel_isEqual(qt_QKeyEvent* pEvent, int keyQt);

#endif
