/***************************************************************************
                            kde_KRuler.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KRULER
#define KDE_KRULER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 A ruler widget.

 The vertical ruler looks similar to this:

<pre>
    meters                       inches

    ------   <--- end mark  ---> ------
        --                            -
        --   <---little mark--->     --
        --                            -
        --                          ---
       ---   <---medium mark          -
        --                           --
        --        tiny mark---->      -
        --                         ----
        --                            -
      ----   <-----big mark          --
        --                            -
      |>--   <--ruler pointer-->   |>--

 </pre>

 There are tiny marks, little marks, medium marks, and big marks along the
  ruler.

 To receive mouse clicks or mouse moves,
 the class has to be overloaded.

 For performance reasons, the public methods don't call @ref QWidget::repaint().
 (Slots do, see documentation below.)
 All the changed settings will be painted once after leaving
 to the main event loop.
 For performance painting the slot methods should be used,
 they do a fast @ref QWidget::repaint() call after changing the values.
 For setting multiple values like @ref minValue(), @ref maxValue(), @ref offset() etc.
 using the public methods is recommended
 so the widget will be painted only once when entering the main event loop.

 @author Jrg Habenicht
 
 @short A ruler widget.

*/
#define KRULER_Custom	0
#define KRULER_Pixel	0
#define KRULER_Inch	1
#define KRULER_Millimetres	2
#define KRULER_Centimetres	3
#define KRULER_Metres	4

/** 
 Constructs a horizontal ruler.
   
*/
kde_KRuler * kde_new_KRuler(qt_QWidget * parent, char* name);

/** 
 Constructs a ruler with orientation @p orient.

 @p parent, @p name and @p f are passed to QFrame.
 The default look is a raised widget
 but may be changed with the inherited @ref QFrame methods.

*/
kde_KRuler * kde_new_KRuler1(int orient, qt_QWidget * parent, char* name, int f);

/** 
 Constructs a ruler with orientation @p orient and initial width @p widgetWidth.

 The width sets the fixed width of the widget. This is useful if you
 want to draw the ruler bigger or smaller than the default size.
 Note: The size of the marks doesn't change.
 @p parent, @p name and @p f are passed to @ref QFrame.

   
*/
kde_KRuler * kde_new_KRuler2(int orient, int widgetWidth, qt_QWidget * parent, char* name, int f);

/** 
 Destructor.
   
*/
void kde_del_KRuler( kde_KRuler* p );

/** 
 Sets the minimal value of the ruler pointer (default is 0).

 This method calls @ref update() so that the widget is painted after leaving
 to the main event loop.

*/
void kde_KRuler_setMinValue(kde_KRuler* instPointer,int arg1);

/** 
 Returns the minimal value of the ruler pointer.

*/
int kde_KRuler_minValue(kde_KRuler* instPointer);

/** 
 Sets the maximum value of the ruler pointer (default is 100).

 This method calls @ref update() so that the widget is painted after leaving
 to the main event loop.
   
*/
void kde_KRuler_setMaxValue(kde_KRuler* instPointer,int arg1);

/** 
 Returns the maximal value of the ruler pointer.
   
*/
int kde_KRuler_maxValue(kde_KRuler* instPointer);

/** 
 Sets minimum and maximum values of the ruler pointer.

 This method calls @ref update() so that the widget is painted after leaving
 to the main event loop.
   
*/
void kde_KRuler_setRange(kde_KRuler* instPointer,int min, int max);

/** 
 Sets the value of the ruler pointer.

 The value is indicated by painting the ruler pointer at the
 corresponding position.
 This method calls @ref update() so that the widget is painted after leaving
 to the main event loop.
   
*/
void kde_KRuler_setValue(kde_KRuler* instPointer,int arg1);
int kde_KRuler_value(kde_KRuler* instPointer);

/** 
 Sets the distance between tiny marks.

 This is mostly used in the English system (inches) with distance of 1. 
   
*/
void kde_KRuler_setTinyMarkDistance(kde_KRuler* instPointer,int arg1);

/** 
 Returns the distance between tiny marks.

*/
int kde_KRuler_tinyMarkDistance(kde_KRuler* instPointer);

/**  
 Sets the distance between little marks.

 The default value is 1 in the metric system and 2 in the English (inches) system.
   
*/
void kde_KRuler_setLittleMarkDistance(kde_KRuler* instPointer,int arg1);

/**  
 Returns the distance between little marks.
   
*/
int kde_KRuler_littleMarkDistance(kde_KRuler* instPointer);

/** 
 Sets the distance between medium marks.

 For English (inches) styles it defaults to twice the little mark distance.
 For metric styles it defaults to five times the little mark distance.

*/
void kde_KRuler_setMediumMarkDistance(kde_KRuler* instPointer,int arg1);
int kde_KRuler_mediumMarkDistance(kde_KRuler* instPointer);

/**  
 Sets distance between big marks.

 For English (inches) or metric styles it is twice the medium mark distance.

*/
void kde_KRuler_setBigMarkDistance(kde_KRuler* instPointer,int arg1);

/** 
 Returns the distance between big marks.

*/
int kde_KRuler_bigMarkDistance(kde_KRuler* instPointer);

/** 
 Shows/hides tiny marks.

*/
void kde_KRuler_setShowTinyMarks(kde_KRuler* instPointer,int arg1);
int kde_KRuler_showTinyMarks(kde_KRuler* instPointer);

/** 
 Shows/hides little marks.

*/
void kde_KRuler_setShowLittleMarks(kde_KRuler* instPointer,int arg1);
int kde_KRuler_showLittleMarks(kde_KRuler* instPointer);

/** 
 Shows/hides medium marks.

*/
void kde_KRuler_setShowMediumMarks(kde_KRuler* instPointer,int arg1);
int kde_KRuler_showMediumMarks(kde_KRuler* instPointer);

/** 
 Shows/hides big marks.

*/
void kde_KRuler_setShowBigMarks(kde_KRuler* instPointer,int arg1);
int kde_KRuler_showBigMarks(kde_KRuler* instPointer);

/** 
 Shows/hides end marks.

*/
void kde_KRuler_setShowEndMarks(kde_KRuler* instPointer,int arg1);
int kde_KRuler_showEndMarks(kde_KRuler* instPointer);

/** 
 Shows/hides the pointer.
   
*/
void kde_KRuler_setShowPointer(kde_KRuler* instPointer,int arg1);
int kde_KRuler_showPointer(kde_KRuler* instPointer);

/** 
 Sets the value that is shown per little mark.

 For metric systems this is 1 per mark.
 Note: If you set the value for little marks the values for 
 medium and big marks are updated according to the
 the values set in the setXXMarkDistance(int) methods.

*/
void kde_KRuler_setValuePerLittleMark(kde_KRuler* instPointer,int arg1);

/** 
 Sets the value that is shown per medium mark.

 For metric systems this is 5.
 Display of little marks is automatically disabled and
 big marks are updated according to 
 the values set in the @ref setBigMarkDistance() method.

*/
void kde_KRuler_setValuePerMediumMark(kde_KRuler* instPointer,int arg1);

/** 
 Sets the value that is shown per big mark.

 For metric systems this is 1
 Display of little and medium marks marks is disabled.
   
*/
void kde_KRuler_setValuePerBigMark(kde_KRuler* instPointer,int arg1);

/** 
 Show/hide number values of the end marks.

 Default is @p false.

*/
void kde_KRuler_setShowEndLabel(kde_KRuler* instPointer,int arg1);
int kde_KRuler_showEndLabel(kde_KRuler* instPointer);

/** 
 Sets the label this is drawn at the beginning of the visible part
 of the ruler to @p label

*/
void kde_KRuler_setEndLabel(kde_KRuler* instPointer,qt_QString * arg1);
qt_QString * kde_KRuler_endLabel(kde_KRuler* instPointer);

/** 
 Sets up the necessary tasks for the provided styles.

 A convenience method.

*/
void kde_KRuler_setRulerMetricStyle(kde_KRuler* instPointer,int arg1);

/** 
 Sets the number of pixels between two base marks.

 Calling this method stretches or shrinks your ruler.

 For pixel display (@ref MetricStyle) the value is 10.0 marks
 per pixel ;-)
 For English (inches) it is 9.0, and for centimetres ~2.835 -> 3.0 .
 If you want to magnify your part of display, you have to
 adjust the mark distance @p here.
 Notice: The double type is only supported to give the possibility
         of having some double values.
         It should be used with care.  Using values below 10.0
         shows visible jumps of markpositions (e.g. 2.345).
         Using whole numbers is highly recommended.
 To use @p int values use setPixelPerMark((int)your_int_value);
 default: 1 mark per 10 pixels 
   
*/
void kde_KRuler_setPixelPerMark(kde_KRuler* instPointer,double rate);

/** 
 Returns the number of pixels between two base marks.

*/
double kde_KRuler_pixelPerMark(kde_KRuler* instPointer);

/** 
 Sets the length of the ruler, i.e. the difference between
 the begin mark and the end mark of the ruler.

 Same as (width() - offset())

 when the length is not locked, it gets adjusted with the
 length of the widget.
   
*/
void kde_KRuler_setLength(kde_KRuler* instPointer,int arg1);
int kde_KRuler_length(kde_KRuler* instPointer);

/** 
 Locks the length of the ruler, i.e. the difference between
 the two end marks doesn't change when the widget is resized.

*/
void kde_KRuler_setLengthFixed(kde_KRuler* instPointer,int fix);
int kde_KRuler_lengthFixed(kde_KRuler* instPointer);

/** 
 Sets the number of pixels by which the ruler may slide up or left.
 The number of pixels moved is realive to the previous position.
 The Method makes sense for updating a ruler, which is working with 
 a scrollbar.

 This doesn't affect the position of the ruler pointer.
 Only the visible part of the ruler is moved.

*/
void kde_KRuler_slideUp(kde_KRuler* instPointer,int count);

/** 
 Sets the number of pixels by which the ruler may slide down or right.
 The number of pixels moved is realive to the previous position.
 The Method makes sense for updating a ruler, which is working with 
 a scrollbar.

 This doesn't affect the position of the ruler pointer.
 Only the visible part of the ruler is moved.

*/
void kde_KRuler_slideDown(kde_KRuler* instPointer,int count);

/** 
 Sets the ruler slide offset.

 This is like @ref slideup() or @ref slidedown() with an absolute offset
 from the start of the ruler.

*/
void kde_KRuler_setOffset(kde_KRuler* instPointer,int offset);

/** 
 Returns the current ruler offset.

*/
int kde_KRuler_offset(kde_KRuler* instPointer);
int kde_KRuler_endOffset(kde_KRuler* instPointer);

/** 
 Sets the pointer to a new position.

 The offset is NOT updated.
 @ref QWidget::repaint() is called afterwards.

*/
void kde_KRuler_slotNewValue(kde_KRuler* instPointer,int arg1);

/** 
 Sets the ruler marks to a new position.

 The pointer is NOT updated.
 @ref QWidget::repaint() is called afterwards.

*/
void kde_KRuler_slotNewOffset(kde_KRuler* instPointer,int arg1);
void kde_KRuler_slotEndOffset(kde_KRuler* instPointer,int arg1);

#endif
