/***************************************************************************
                            kde_KRecentDocument.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KRECENTDOCUMENT
#define KDE_KRECENTDOCUMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Manage the "Recent Document Menu" entries displayed by
 applications such as Kicker and Konqueror.

 These entries are automatically generated .desktop files pointing
 to the current application and document.  You should call the
 static @ref add() method whenever the user opens or saves a new
 document if you want it to show up in the menu.

 You don't have to worry about this if you are using any @ref
 KFileDialog derived class to open and save documents, as it
 already calls this class.  User defined limits on the maximum
 number of documents to save, etc... are all automatically handled.

 @author Daniel M. Duley <mosfet@kde.org> 
 
 @short 
 Manage the "Recent Document Menu" entries displayed by
 applications such as Kicker and Konqueror.
*/

/** 

 Return a list of absolute paths to recent document .desktop files,
 sorted by date.

     
*/
qt_QStringList* kde_KRecentDocument_recentDocuments( );

/** 
 Add a new item to the Recent Document menu.

*/
void kde_KRecentDocument_add( kde_KURL* url);

/** 

 Add a new item to the Recent Document menu. Calls add( url ).

*/
void kde_KRecentDocument_add1( qt_QString * documentStr, int isURL);

/** 
 Clear the recent document menu of all entries.
     
*/
void kde_KRecentDocument_clear( );

/** 
 Returns the maximum amount of recent document entries allowed.
     
*/
int kde_KRecentDocument_maximumItems( );

/** 
 Returns the path to the directory where recent document .desktop files
 are stored.
     
*/
qt_QString * kde_KRecentDocument_recentDocumentDirectory( );

#endif
