/***************************************************************************
                            kde_KProtocolInfo.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPROTOCOLINFO
#define KDE_KPROTOCOLINFO

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Information about I/O (Internet, etc.) protocols supported by KDE.

 This class is useful if you want to know which protocols
 KDE supports. In addition you can find out lots of information
 about a certain protocol. KProtocolInfo scans the *.protocol
 files of all installed kioslaves to get this information.

 *.protocol files are installed in the "services" resource.

 @author Torben Weis <weis@kde.org>
 
 @short 
 Information about I/O (Internet, etc.
*/
#define KPROTOCOLINFO_T_STREAM	0
#define KPROTOCOLINFO_T_FILESYSTEM	1
#define KPROTOCOLINFO_T_NONE	2
#define KPROTOCOLINFO_T_ERROR	3

/** 
 Read a protocol description file
   
*/
kde_KProtocolInfo * kde_new_KProtocolInfo(qt_QString * path);

/** 

*/
int kde_KProtocolInfo_isValid(kde_KProtocolInfo* instPointer);

/** 

 This corresponds to the "protocol=" field in the protocol description file.

*/
qt_QString * kde_KProtocolInfo_name(kde_KProtocolInfo* instPointer);

/** 

   
*/
kde_KProtocolInfo * kde_new_KProtocolInfo1(qt_QDataStream * _str, int offset);
void kde_del_KProtocolInfo( kde_KProtocolInfo* p );

/** 

 Load the protocol info from a stream.
   
*/
void kde_KProtocolInfo_load(kde_KProtocolInfo* instPointer,qt_QDataStream * arg1);

/** 

 Save the protocol info to a stream.
   
*/
void kde_KProtocolInfo_save(kde_KProtocolInfo* instPointer,qt_QDataStream * arg1);

/** 

*/
qt_QStringList* kde_KProtocolInfo_protocols( );

/** 

*/
int kde_KProtocolInfo_isKnownProtocol( kde_KURL* url);

/** 

 This corresponds to the "exec=" field in the protocol description file.

   
*/
qt_QString * kde_KProtocolInfo_exec( qt_QString * protocol);

/**  

 This corresponds to the "input=" field in the protocol description file.
 Valid values for this field are "filesystem", "stream" or "none" (default).

   
*/
int kde_KProtocolInfo_inputType( kde_KURL* url);

/**  

 This corresponds to the "output=" field in the protocol description file.
 Valid values for this field are "filesystem", "stream" or "none" (default).

   
*/
int kde_KProtocolInfo_outputType( kde_KURL* url);

/** 

 This corresponds to the "listing=" field in the protocol description file.
 The supported fields should be seperated with ',' in the protocol description file.
   
*/
qt_QStringList* kde_KProtocolInfo_listing( kde_KURL* url);

/** 

 The "source=" field in the protocol description file determines
 whether a protocol is a source protocol or a filter protocol.
 Valid values for this field are "true" (default) for source protocol or 
 "false" for filter protocol.
   
*/
int kde_KProtocolInfo_isSourceProtocol( kde_KURL* url);

/** 

 This corresponds to the "helper=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
int kde_KProtocolInfo_isHelperProtocol( kde_KURL* url);

/** 

 The "source=" field in the protocol description file determines
 whether a protocol is a source protocol or a filter protocol.
 Valid values for this field are "true" (default) for source protocol or 
 "false" for filter protocol.
   
*/
int kde_KProtocolInfo_isFilterProtocol( kde_KURL* url);

/** 

 Whether a protocol supports listing is determined by the "listing=" 
 field in the protocol description file.
 If the protocol support listing it should list the fields it provides in
 this field. If the protocol does not support listing this field should
 remain empty (default.)

*/
int kde_KProtocolInfo_supportsListing( kde_KURL* url);

/** 

 This corresponds to the "reading=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
int kde_KProtocolInfo_supportsReading( kde_KURL* url);

/** 

 This corresponds to the "writing=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
int kde_KProtocolInfo_supportsWriting( kde_KURL* url);

/** 

 This corresponds to the "makedir=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
int kde_KProtocolInfo_supportsMakeDir( kde_KURL* url);

/** 

 This corresponds to the "deleting=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
int kde_KProtocolInfo_supportsDeleting( kde_KURL* url);

/** 

 This corresponds to the "linking=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
int kde_KProtocolInfo_supportsLinking( kde_KURL* url);

/** 

 This corresponds to the "moving=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
int kde_KProtocolInfo_supportsMoving( kde_KURL* url);

/** 

 This corresponds to the "copyFromFile=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
int kde_KProtocolInfo_canCopyFromFile( kde_KURL* url);

/** 

 This corresponds to the "copyToFile=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
int kde_KProtocolInfo_canCopyToFile( kde_KURL* url);

/** 

 This corresponds to the "defaultMimetype=" field in the protocol description file.
   
*/
qt_QString * kde_KProtocolInfo_defaultMimetype( kde_KURL* url);

/** 

 This corresponds to the "Icon=" field in the protocol description file.
   
*/
qt_QString * kde_KProtocolInfo_icon( qt_QString * protocol);

/** 

 This corresponds to the "config=" field in the protocol description file.
 The default is the protocol name, see @ref name()
   
*/
qt_QString * kde_KProtocolInfo_config( qt_QString * protocol);

/** 

 This corresponds to the "maxInstances=" field in the protocol description file.
 The default is 1.
   
*/
int kde_KProtocolInfo_maxSlaves( qt_QString * protocol);

/** 

 This corresponds to the "determineMimetypeFromExtension=" field in the protocol description file.
 Valid values for this field are "true" (default) or "false".
   
*/
int kde_KProtocolInfo_determineMimetypeFromExtension( qt_QString * protocol);
int kde_KProtocolInfo_inputType1( qt_QString * protocol);
int kde_KProtocolInfo_outputType1( qt_QString * protocol);

/** 

*/
qt_QStringList* kde_KProtocolInfo_listing1( qt_QString * protocol);
int kde_KProtocolInfo_isSourceProtocol1( qt_QString * protocol);
int kde_KProtocolInfo_isHelperProtocol1( qt_QString * protocol);
int kde_KProtocolInfo_isFilterProtocol1( qt_QString * protocol);
int kde_KProtocolInfo_isKnownProtocol1( qt_QString * protocol);
int kde_KProtocolInfo_supportsListing1( qt_QString * protocol);
int kde_KProtocolInfo_supportsReading1( qt_QString * protocol);
int kde_KProtocolInfo_supportsWriting1( qt_QString * protocol);
int kde_KProtocolInfo_supportsMakeDir1( qt_QString * protocol);
int kde_KProtocolInfo_supportsDeleting1( qt_QString * protocol);
int kde_KProtocolInfo_supportsLinking1( qt_QString * protocol);
int kde_KProtocolInfo_supportsMoving1( qt_QString * protocol);
int kde_KProtocolInfo_canCopyFromFile1( qt_QString * protocol);
int kde_KProtocolInfo_canCopyToFile1( qt_QString * protocol);
qt_QString * kde_KProtocolInfo_defaultMimetype1( qt_QString * protocol);

#endif
