/***************************************************************************
                            kde_KAboutData.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KABOUTDATA
#define KDE_KABOUTDATA

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 This class is used to store information about a program. It can store
 such values as version number, program name, home page, email address
 for bug reporting, multiple authors and contributors
 (using @ref KAboutPerson), license and copyright information.

 Currently, the values set here are shown by the "About" box
 (see @ref KAboutDialog), used by the bug report dialog (see @ref KBugReport),
 and by the help shown on command line (see @ref KCmdLineArgs).

 @author Espen Sand (espen@kde.org), David Faure (faure@kde.org)

 @version $Id: kde_KAboutData.h,v 1.3 2002/02/21 00:43:08 rdale Exp $
 
 @short Holds information needed by the "About" box and other
 classes.

*/
#define KABOUTDATA_License_Custom	-2
#define KABOUTDATA_License_File	-1
#define KABOUTDATA_License_Unknown	0
#define KABOUTDATA_License_GPL	1
#define KABOUTDATA_License_GPL_V2	1
#define KABOUTDATA_License_LGPL	2
#define KABOUTDATA_License_LGPL_V2	2
#define KABOUTDATA_License_BSD	3
#define KABOUTDATA_License_Artistic	4
#define KABOUTDATA_License_QPL	5
#define KABOUTDATA_License_QPL_V1_0	5

/** 
 Constructor.

     
*/
kde_KAboutData * kde_new_KAboutData(char* appName, char* programName, char* version, char* shortDescription, int licenseType, char* copyrightStatement, char* text, char* homePageAddress, char* bugsEmailAddress);
void kde_del_KAboutData( kde_KAboutData* p );

/** 
 Defines an author. You can call this function as many times you
 need. Each entry is appended to a list. The person in the first entry
 is assumed to be the leader of the project.

     
*/
void kde_KAboutData_addAuthor(kde_KAboutData* instPointer,char* name, char* task, char* emailAddress, char* webAddress);

/** 
 Defines a person that deserves credit. You can call this function
 as many times you need. Each entry is appended to a list.

     
*/
void kde_KAboutData_addCredit(kde_KAboutData* instPointer,char* name, char* task, char* emailAddress, char* webAddress);

/** 
 Sets the name of the translator of the gui. Since this depends
 on the language, just use a dummy text marked for translation.

 For example:
 setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names")
 ,I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));

 The translator can then translate this dummy text with his name
 or with a list of names separated with ",".
 If there is no translation or the application is used with the
 default language, this function call is ignored.

 Note: If you are using the default KDE automake environment,
 there is no need to use this function, because the two
 default strings above are added to the applications po file
 automatically.

*/
void kde_KAboutData_setTranslator(kde_KAboutData* instPointer,char* name, char* emailAddress);

/** 
 Defines a licence text.

 The text will be translated if it got marked for
 translations with the I18N_NOOP() macro.

 Example:
 setLicenseText( I18N_NOOP("This is my license"));

 NOTE: No copy of the text is made.
     
*/
void kde_KAboutData_setLicenseText(kde_KAboutData* instPointer,char* license);

/** 
 Defines a licence text. 

*/
void kde_KAboutData_setLicenseTextFile(kde_KAboutData* instPointer,qt_QString * file);

/** 

*/
char* kde_KAboutData_appName(kde_KAboutData* instPointer);

/** 

*/
qt_QString * kde_KAboutData_programName(kde_KAboutData* instPointer);

/** 

*/
qt_QString * kde_KAboutData_version(kde_KAboutData* instPointer);

/** 

*/
qt_QString * kde_KAboutData_shortDescription(kde_KAboutData* instPointer);

/** 

*/
qt_QString * kde_KAboutData_homepage(kde_KAboutData* instPointer);

/** 

*/
qt_QString * kde_KAboutData_bugAddress(kde_KAboutData* instPointer);

/** 

*/
qt_QString * kde_KAboutData_otherText(kde_KAboutData* instPointer);

/** 
 Returns the license. If the licenseType argument of the constructor has been
 used, any text defined by @ref setLicenseText is ignored,
 and the standard text for the chosen license will be returned.

*/
qt_QString * kde_KAboutData_license(kde_KAboutData* instPointer);

/** 

*/
qt_QString * kde_KAboutData_copyrightStatement(kde_KAboutData* instPointer);

/**  

*/
qt_QString * kde_KAboutData_aboutTranslationTeam( );

#endif
