// Widget for selecting file permissions...
#include "Permissions.moc"
#include <kapplication.h>
#include <klocale.h>
#include <qsize.h>

Permissions::Permissions(unsigned short initial, QWidget *parent, const char *name):QWidget(parent, name)
{
	Special=new QLabel(i18n("Special:"),this);
	Owner=new QLabel(i18n("Owner:"),this);
	Group=new QLabel(i18n("Group:"),this);
	Other=new QLabel(i18n("Other:"),this);
	SetUID=new QCheckBox(i18n("Set&UID"),this);
	SetGID=new QCheckBox(i18n("Set&GID"),this);
	Sticky=new QCheckBox(i18n("Stick&y"),this);
	OwnerR=new QCheckBox(i18n("&Read"),this);
	OwnerW=new QCheckBox(i18n("&Write"),this);
	OwnerX=new QCheckBox(i18n("&Execute"),this);
	GroupR=new QCheckBox(i18n("Re&ad"),this);
	GroupW=new QCheckBox(i18n("Wr&ite"),this);
	GroupX=new QCheckBox(i18n("E&xecute"),this);
	OtherR=new QCheckBox(i18n("Rea&d"),this);
	OtherW=new QCheckBox(i18n("Wri&te"),this);
        OtherX=new QCheckBox(i18n("Exe&cute"),this);
        for(int i=0;i<5;i++) {
            Line[i]=new QFrame(this);
            Line[i]->setFrameStyle(QFrame::HLine|QFrame::Sunken);
        }
        for(int i=5;i<10;i++) {
            Line[i]=new QFrame(this);
            Line[i]->setFrameStyle(QFrame::VLine|QFrame::Sunken);
        }
        setValue(initial);
	setGeometry(x(),y(),width(),height()); // setGeometry sets the coordinates - no need to do it twice.
}
Permissions::~Permissions()
{
}
void Permissions::resize(int w, int h)
{
    const int x[5] = { 0, w/4, w/2, w*3/4, w-2 };
    int usedH;
    QWidget::resize(w,h);
    int y=0, ih=Special->height();
    Special->setGeometry(x[0]+5,y,x[1]-5,ih);
    Owner->setGeometry(x[1]+5,y,x[1]-5,ih);
    Group->setGeometry(x[2]+5,y,x[1]-5,ih);
    Other->setGeometry(x[3]+5,y,x[1]-5,ih);
    y+=Special->height();
    SetUID->setGeometry(x[0]+5,y,x[1]-5,ih);
    OwnerR->setGeometry(x[1]+5,y,x[1]-5,ih);
    GroupR->setGeometry(x[2]+5,y,x[1]-5,ih);
    OtherR->setGeometry(x[3]+5,y,x[1]-5,ih);
    y+=OwnerR->height();
    SetGID->setGeometry(x[0]+5,y,x[1]-5,ih);
    OwnerW->setGeometry(x[1]+5,y,x[1]-5,ih);
    GroupW->setGeometry(x[2]+5,y,x[1]-5,ih);
    OtherW->setGeometry(x[3]+5,y,x[1]-5,ih);
    y+=SetGID->height();
    Sticky->setGeometry(x[0]+5,y,x[1]-5,ih);
    OwnerX->setGeometry(x[1]+5,y,x[1]-5,ih);
    GroupX->setGeometry(x[2]+5,y,x[1]-5,ih);
    OtherX->setGeometry(x[3]+5,y,x[1]-5,ih);
    usedH=OtherX->y()+OtherX->height();
    y=0;
    for(int i=0;i<5;i++) {
        Line[i]->setGeometry(0,y,x[4],2);
        y+=Special->height();
    }
    for(int i=0;i<5;i++)
        Line[i+5]->setGeometry(x[i],0,2,usedH);
}
QSize Permissions::sizeHint() const
{
    int w;
    w=Special->sizeHint().width();
    if(SetUID->sizeHint().width()>w)
        w=SetUID->sizeHint().width();
    if(SetGID->sizeHint().width()>w)
        w=SetGID->sizeHint().width();
    if(Sticky->sizeHint().width()>w)
        w=Sticky->sizeHint().width();
    if(Owner->sizeHint().width()>w)
        w=Owner->sizeHint().width();
    if(OwnerR->sizeHint().width()>w)
        w=OwnerR->sizeHint().width();
    if(OwnerW->sizeHint().width()>w)
        w=OwnerW->sizeHint().width();
    if(OwnerX->sizeHint().width()>w)
        w=OwnerX->sizeHint().width();
    if(Group->sizeHint().width()>w)
        w=Group->sizeHint().width();
    if(GroupR->sizeHint().width()>w)
        w=GroupR->sizeHint().width();
    if(GroupW->sizeHint().width()>w)
        w=GroupW->sizeHint().width();
    if(GroupX->sizeHint().width()>w)
        w=GroupX->sizeHint().width();
    if(Other->sizeHint().width()>w)
        w=Other->sizeHint().width();
    if(OtherR->sizeHint().width()>w)
        w=OtherR->sizeHint().width();
    if(OtherW->sizeHint().width()>w)
        w=OtherW->sizeHint().width();
    if(OtherX->sizeHint().width()>w)
        w=OtherX->sizeHint().width();
    w+=8;
    return QSize(w*4,Owner->height()+OwnerR->height()+OwnerW->height()+OwnerX->height()+2);
}
void Permissions::setEnabled(bool enable)
{
	SetUID->setEnabled(enable);
	SetGID->setEnabled(enable);
	Sticky->setEnabled(enable);
        OwnerR->setEnabled(enable);
        OwnerW->setEnabled(enable);
        OwnerX->setEnabled(enable);
        GroupR->setEnabled(enable);
        GroupW->setEnabled(enable);
        GroupX->setEnabled(enable);
        OtherR->setEnabled(enable);
        OtherW->setEnabled(enable);
        OtherX->setEnabled(enable);
}
void Permissions::setValue(unsigned short mode)
{
	SetUID->setChecked((mode&04000)==04000);
	SetGID->setChecked((mode&02000)==02000);
	Sticky->setChecked((mode&01000)==01000);
	OwnerR->setChecked((mode&00400)==00400);
	OwnerW->setChecked((mode&00200)==00200);
	OwnerX->setChecked((mode&00100)==00100);
	GroupR->setChecked((mode&00040)==00040);
	GroupW->setChecked((mode&00020)==00020);
	GroupX->setChecked((mode&00010)==00010);
	OtherR->setChecked((mode&00004)==00004);
	OtherW->setChecked((mode&00002)==00002);
	OtherX->setChecked((mode&00001)==00001);
}
void Permissions::setGeometry(int x, int y, int w, int h)
{
	move(x,y);
	resize(w,h);
}
unsigned short Permissions::value()
{
	return	 04000*SetUID->isChecked()+02000*SetGID->isChecked()+01000*Sticky->isChecked()
		+00400*OwnerR->isChecked()+00200*OwnerW->isChecked()+00100*OwnerX->isChecked()
		+00040*GroupR->isChecked()+00020*GroupW->isChecked()+00010*GroupX->isChecked()
		+00004*OtherR->isChecked()+00002*OtherW->isChecked()+00001*OtherX->isChecked();
}
