//////////////////////////////////////////////////////////////
//      $Id: debAptInterface.h,v 1.12 2002/01/27 06:30:43 toivo Exp $ 
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef DEBAPT_IFACE_H
#define DEBAPT_IFACE_H

#include "../config.h"

#include <kaction.h>

#include "debInterface.h"

class DEBAPT: public DEB
{
  Q_OBJECT

public:
  DEBAPT();
  ~DEBAPT();

  virtual bool isType(char *buf, const QString &fname);

  void listPackages(QPtrList<packageInfo> *pki);
  QStringList listInstalls(QStringList packs, bool install);

  QString doUninstall(int uninstallFlags, QString packs, bool &test);
  QString doInstall(int installFlags, QString packs, bool &test);
  QString install(int installFlags, QPtrList<packageInfo> *p,
		  bool &test);

  void listRemotePackages(QPtrList<packageInfo> *pki);
  QStringList getFileList(packageInfo *p);

  KAction *updateM, *upgradeM, *fixupM;

  void makeMenu(KAccel *keys, KActionCollection* act);
  void setMenu(KActionCollection* act, bool enable);

private slots:
  void updateS();	
  void upgradeS();
  void fixupS();

private:
  void listAvail(QPtrList<packageInfo> *pki);
  void listRPack(QPtrList<packageInfo> *pki);
  QStringList getRFileList(packageInfo *p);

};
#endif
