/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

abstract class AbstractFilter
extends OutputStream {
    protected char[] translationTable = latin1TranslationTable;
    protected boolean[] specialsTable = noSpecialsTable;
    static final char[] latin1TranslationTable;
    static final boolean[] noSpecialsTable;
    static final boolean[] allSpecialsTable;

    public void readFromStream(InputStream inputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[16384];
        while ((n2 = inputStream.read(byArray)) >= 0) {
            this.write(byArray, 0, n2);
        }
    }

    public void readFromReader(Reader reader) throws IOException {
        int n2;
        char[] cArray = new char[2048];
        while ((n2 = reader.read(cArray)) >= 0) {
            int n3 = 0;
            while (n3 < n2) {
                this.write(cArray[n3]);
                ++n3;
            }
        }
    }

    public void write(int n2) throws IOException {
        if (n2 < 0) {
            n2 += 256;
        }
        if (this.specialsTable[n2]) {
            this.writeSpecial(n2);
        } else {
            char c2 = this.translationTable[n2];
            if (c2 != '\u0000') {
                this.write(c2);
            }
        }
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        StringBuffer stringBuffer = null;
        while (n3 > 0) {
            short s2 = byArray[n2];
            if (s2 < 0) {
                s2 = (short)(s2 + 256);
            }
            if (this.specialsTable[s2]) {
                if (stringBuffer != null) {
                    this.write(stringBuffer.toString());
                    stringBuffer = null;
                }
                this.writeSpecial(s2);
            } else {
                char c2 = this.translationTable[s2];
                if (c2 != '\u0000') {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(c2);
                }
            }
            --n3;
            ++n2;
        }
        if (stringBuffer != null) {
            this.write(stringBuffer.toString());
        }
    }

    public void write(String string) throws IOException {
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            this.write(string.charAt(n3));
            ++n3;
        }
    }

    protected abstract void write(char var1) throws IOException;

    protected abstract void writeSpecial(int var1) throws IOException;

    static {
        noSpecialsTable = new boolean[256];
        int n2 = 0;
        while (n2 < 256) {
            AbstractFilter.noSpecialsTable[n2] = false;
            ++n2;
        }
        allSpecialsTable = new boolean[256];
        n2 = 0;
        while (n2 < 256) {
            AbstractFilter.allSpecialsTable[n2] = true;
            ++n2;
        }
        latin1TranslationTable = new char[256];
        n2 = 0;
        while (n2 < 256) {
            AbstractFilter.latin1TranslationTable[n2] = (char)n2;
            ++n2;
        }
    }
}

