/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.protocol.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;

class Connection
extends URLConnection {
    private Hashtable hdrHash;
    private Vector hdrVec;
    private boolean gotHeaders;
    private File fileIn;
    private InputStream inputStream;
    private OutputStream outputStream;

    private /* synthetic */ void finit$() {
        this.hdrHash = new Hashtable();
        this.hdrVec = new Vector();
        this.gotHeaders = false;
    }

    public Connection(URL url) {
        super(url);
        this.finit$();
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        String fname = this.url.getFile();
        this.fileIn = new File(fname);
        if (this.doInput) {
            this.inputStream = new BufferedInputStream(new FileInputStream(this.fileIn));
        }
        if (this.doOutput) {
            this.outputStream = new BufferedOutputStream(new FileOutputStream(this.fileIn));
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        if (!this.connected) {
            this.connect();
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new ProtocolException("Can't open OutputStream if doOutput is false");
        }
        if (!this.connected) {
            this.connect();
        }
        return this.outputStream;
    }

    public String getHeaderField(String name) {
        try {
            this.getHeaders();
        }
        catch (IOException x) {
            return null;
        }
        return (String)this.hdrHash.get(name.toLowerCase());
    }

    public String getHeaderField(int n) {
        try {
            this.getHeaders();
        }
        catch (IOException x) {
            return null;
        }
        if (n < this.hdrVec.size()) {
            return this.getField((String)this.hdrVec.elementAt(n));
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getHeaders();
        }
        catch (IOException x) {
            return null;
        }
        if (n < this.hdrVec.size()) {
            return this.getKey((String)this.hdrVec.elementAt(n));
        }
        return null;
    }

    private String getKey(String str) {
        if (str == null) {
            return null;
        }
        int index = str.indexOf(58);
        if (index >= 0) {
            return str.substring(0, index);
        }
        return null;
    }

    private String getField(String str) {
        if (str == null) {
            return null;
        }
        int index = str.indexOf(58);
        if (index >= 0) {
            return str.substring(index + 1).trim();
        }
        return str;
    }

    private void getHeaders() throws IOException {
        if (this.gotHeaders) {
            return;
        }
        this.gotHeaders = true;
        this.connect();
        long len = this.fileIn.length();
        String line = "Content-length: " + len;
        this.hdrVec.addElement(line);
        String key = this.getKey(line);
        this.hdrHash.put(key.toLowerCase(), Long.toString(len));
    }
}

