config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
for file in etc/cups/*.new ; do
  config $file
done
( cd usr/lib ; rm -rf libcups.so )
( cd usr/lib ; ln -sf libcups.so.2 libcups.so )
( cd usr/lib/cups/backend ; rm -rf http )
( cd usr/lib/cups/backend ; ln -sf ipp http )
( cd usr/lib ; rm -rf libcupsimage.so )
( cd usr/lib ; ln -sf libcupsimage.so.2 libcupsimage.so )
( cd usr/bin ; rm -rf disable )
( cd usr/bin ; ln -sf ../sbin/accept disable )
( cd usr/bin ; rm -rf enable )
( cd usr/bin ; ln -sf ../sbin/accept enable )
( cd usr/sbin ; rm -rf reject )
( cd usr/sbin ; ln -sf accept reject )
( cd usr/man/man1 ; rm -rf cancel.1.gz )
( cd usr/man/man1 ; ln -sf lp.1.gz cancel.1.gz )
( cd usr/man/man8 ; rm -rf reject.8.gz )
( cd usr/man/man8 ; ln -sf accept.8.gz reject.8.gz )
( cd usr/man/man8 ; rm -rf disable.8.gz )
( cd usr/man/man8 ; ln -sf enable.8.gz disable.8.gz )
( cd usr/man/fr/man1 ; rm -rf cancel.1 )
( cd usr/man/fr/man1 ; ln -sf lp.1 cancel.1 )
( cd usr/man/fr/man8 ; rm -rf reject.8 )
( cd usr/man/fr/man8 ; ln -sf accept.8 reject.8 )
( cd usr/man/fr/man8 ; rm -rf disable.8 )
( cd usr/man/fr/man8 ; ln -sf enable.8 disable.8 )
( cd usr/doc ; rm -rf cups )
( cd usr/doc ; ln -sf cups-1.1.15 cups )
