/*
 * main.cpp for lisa,reslisa,kio_lan and kio_rlan kcm module
 *
 *  Copyright (C) 2000 Alexander Neundorf <neundorf@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "kcmlisa.h"
#include "kcmreslisa.h"
#include "kcmkiolan.h"

#include <klocale.h>
#include <qtabwidget.h>
#include <kglobal.h>
#include <qlayout.h>
#include <qlabel.h>

#include <kcmodule.h>

#include <unistd.h>
#include <sys/types.h>

class LisaContainer:public KCModule
{
   public:
      LisaContainer(QWidget *parent=0, const char * name=0);
      virtual ~LisaContainer() {};
      virtual void load();
      virtual void save();
      virtual void defaults() {};
      QString quickHelp() const;

   private:
      QVBoxLayout layout;
      QTabWidget tabs;
      LisaSettings *lisaPage;
      ResLisaSettings resLisaPage;
      IOSlaveSettings kioLanPage;
      IOSlaveSettings kioRLanPage;
};

LisaContainer::LisaContainer(QWidget *parent, const char* name)
:KCModule(parent,name)
,layout(this)
,tabs(this)
,lisaPage(0)
,resLisaPage("reslisarc",&tabs)
,kioLanPage("kio_lanrc", &tabs)
,kioRLanPage("kio_rlanrc", &tabs,true)
{
   layout.addWidget(&tabs);
   if (getuid()==0)
   {
      lisaPage=new LisaSettings("lisarc",&tabs);
      tabs.addTab(lisaPage,i18n("Setup LISa"));
   }
   else
   {
      QWidget *dummy=new QWidget(&tabs);
      QHBoxLayout *hbox = new QHBoxLayout(dummy);
      hbox->addStretch(1);
      QLabel * label=new QLabel(i18n("The LAN Information Server LISa can be configured only\nby the system administrator (root)."),dummy);
      label->setAlignment(Qt::AlignCenter);
      hbox->addWidget(label);
      hbox->addStretch(1);

      tabs.addTab(dummy,i18n("Setup LISa"));
   };
   tabs.addTab(&resLisaPage,i18n("Setup ResLISa"));
   tabs.addTab(&kioLanPage,i18n("Setup the LAN ioslave for LISa"));
   tabs.addTab(&kioRLanPage,i18n("Setup the RLAN ioslave for resLISa"));
   setButtons(Apply|Help);
   load();
};

#include <iostream.h>

void LisaContainer::load()
{
   if (lisaPage!=0)
      lisaPage->load();
   resLisaPage.load();
   kioLanPage.load();
   kioRLanPage.load();
}

void LisaContainer::save()
{
   if (lisaPage!=0)
      lisaPage->save();
   resLisaPage.save();
   kioLanPage.save();
   kioRLanPage.save();
}


QString LisaContainer::quickHelp() const
{
   return i18n("look at the LISa README file for more configuration.");
}


extern "C"
{

  KCModule *create_lanbrowser(QWidget *parent, const char *name)
  {
    KGlobal::locale()->insertCatalogue("kcmlanbrowser");
    return new LisaContainer(parent, name);
  }
}
