#include "prefs.h"
#include "voiceprint.h"

#include <klocale.h>
#include <kglobal.h>
#include <qlabel.h>
#include <qlayout.h>
#include <kcolorbutton.h>
#include <kconfig.h>
#include <iostream.h>

Prefs::Prefs(QWidget* parent, char* name)
	: CModule(parent, name)
{
	QVBoxLayout	*king=new QVBoxLayout(this);
	QHBoxLayout *minor;
	
	QLabel *label;
	mForeground=new KColorButton(this);
	label=new QLabel(mForeground, i18n("&Foreground Color"), this);
	minor=new QHBoxLayout(king);
	minor->addWidget(label);
	minor->addWidget(mForeground);

	mBackground=new KColorButton(this);
	label=new QLabel(mBackground, i18n("&Background Color"), this);
	minor=new QHBoxLayout(king);
	minor->addWidget(label);
	minor->addWidget(mBackground);
	
	mLine=new KColorButton(this);
	label=new QLabel(mForeground, i18n("&Sweep Color"), this);
	minor=new QHBoxLayout(king);
	minor->addWidget(label);
	minor->addWidget(mLine);
}

void Prefs::reopen()
{
	KConfig *config=KGlobal::config();
	config->setGroup("VoicePrint");
        QColor black(0, 0, 0);
        QColor blue(0, 0, 222);
	mBackground->setColor(config->readColorEntry("Background", &black));
	mForeground->setColor(config->readColorEntry("Foreground", &blue));
	mLine->setColor(config->readColorEntry("Line", &black));
}

void Prefs::save()
{
	KConfig *config=KGlobal::config();
	config->setGroup("VoicePrint");
	config->writeEntry("Background", mBackground->color());
	config->writeEntry("Foreground", mForeground->color());
	config->writeEntry("Line", mLine->color());

	config->sync();
	cout << "Save!!" << endl;

	VoicePrint *l=static_cast<VoicePrint*>(napp->libraryLoader()->pluginByName("VoicePrint"));
	if (l)
		l->setColors(mBackground->color(), mForeground->color(), mLine->color());

}

#include "prefs.moc"

