#ifndef PLAYLIST_H
#define PLAYLIST_H

#include <noatunplaylist.h>
#include <plugin.h>

/*
class PlayListItem
{
	PlayListItem(const KURL &u=0);
	virtual ~PlayListItem();

	QString title() const;
	virtual void setTitle(const QString &t);

	KURL url() const;
	virtual void setUrl(const KURL &u);

	int length() const;
	virtual void setLength(int l);
};
*/
class SafeListViewItem;
class View;
class List;
class QListViewItem;

class SplitPlayList : public PlayList, public Plugin
{
Q_OBJECT
NOATUNPLUGIND
friend class SafeListViewItem;
friend class List;
public:
	SplitPlayList();
	~SplitPlayList();
	
	/**
	 * go to the front
	 **/
	virtual void reset();
	
	virtual void clear();
	virtual void addFile(const KURL&, bool play=false);
	/**
	 * Cycle everthing through forward
	 **/
	virtual PlayListItem *next();
	/**
	 * return the one that might/should be playing now
	 **/
	virtual PlayListItem *current();
	/**
	 * Cycle through backwards
	 **/
	virtual PlayListItem *previous();

	virtual PlayListItem *getFirst() const;
	virtual PlayListItem *getAfter(const PlayListItem *item) const;
		
	virtual bool listVisible() const;
	virtual void init();
	
	virtual PlayList *playlist() const
		{ return (PlayList *)this; }

	static SplitPlayList *SPL() { return Self; }
public slots:	
	virtual void showList();
	virtual void hideList();
	virtual void remove(PlayListItem*);

		
public slots:
	void setNext(PlayListItem *);
	void setCurrent(PlayListItem *);
	void setPrevious(PlayListItem *);
	
	void listItemSelected(QListViewItem*);

	void randomize();

private:
	PlayListItem *nextItem, *currentItem, *previousItem;

signals:
	void play(PlayListItem*);

	
private:
	View *view;
//	QRect currentRect;
	static SplitPlayList *Self;
};


#endif
