#include "playlist.h"
#include "view.h"
#include <player.h>

#include <krandomsequence.h>

SplitPlayList *SplitPlayList::Self=0;

SplitPlayList::SplitPlayList()
	: PlayList(0, "SplitPlayList"), Plugin(), nextItem(0), currentItem(0), previousItem(0)
{
	Self=this;
	NOATUNPLUGINC(SplitPlayList);
}

void SplitPlayList::init()
{
	view=new View(this);
	connect(view->listView(), SIGNAL(doubleClicked(QListViewItem*)), SLOT(listItemSelected(QListViewItem*)));
	connect(view, SIGNAL(shown()), SIGNAL(listShown()));
	connect(view, SIGNAL(hidden()), SIGNAL(listHidden()));
	
	view->init();
}

SplitPlayList::~SplitPlayList()
{
	delete view;
}

void SplitPlayList::reset()
{
	previousItem=0;
	SafeListViewItem *i;
	setCurrent(i=static_cast<SafeListViewItem*>(view->listView()->firstChild()));
	if (i && !i->isOn())
		next();
}
	
PlayListItem *SplitPlayList::next()
{
	if (!nextItem) return 0;
	setCurrent(nextItem);
	if (currentItem)
		if (!static_cast<SafeListViewItem*>(currentItem)->isOn())
			return next();
	
	return currentItem;
}

PlayListItem *SplitPlayList::current()
{
	return currentItem;
}

PlayListItem *SplitPlayList::previous()
{
	if (!previousItem) return 0;
	setCurrent(previousItem);
	
	if (currentItem)
		if (!static_cast<SafeListViewItem*>(currentItem)->isOn())
			return previous();

	return currentItem;
}

PlayListItem *SplitPlayList::getFirst() const
{
	return static_cast<SafeListViewItem*>(view->listView()->firstChild());
}

PlayListItem *SplitPlayList::getAfter(const PlayListItem *item) const
{
	return static_cast<SafeListViewItem*>(static_cast<const SafeListViewItem*>(item)->nextSibling());
}
	
bool SplitPlayList::listVisible() const
{
	return view->isVisible();
}

void SplitPlayList::showList()
{
	view->show();
}

void SplitPlayList::hideList()
{
	view->hide();
}

void SplitPlayList::clear()
{
	view->listView()->clear();
}

void SplitPlayList::addFile(const KURL &file, bool play)
{
	view->addFile(file, play);
}

void SplitPlayList::setNext(PlayListItem *i)
{
	nextItem=i;
}

void SplitPlayList::setCurrent(PlayListItem *i)
{
	bool emitC=currentItem==0;
	if (!i)
	{
		currentItem=0;
		return;
	}
	QRect rect(view->listView()->itemRect(static_cast<SafeListViewItem*>(current())));
	rect.setWidth(view->listView()->viewport()->width());
	currentItem=i;	
	view->listView()->viewport()->repaint(rect,true);

	view->listView()->ensureItemVisible(static_cast<SafeListViewItem*>(current()));
	QRect currentRect= view->listView()->itemRect(static_cast<SafeListViewItem*>(current()));
	view->listView()->viewport()->repaint(currentRect);
	
	setNext(static_cast<PlayListItem*>(static_cast<SafeListViewItem*>(static_cast<SafeListViewItem*>(current())->itemBelow())));
	setPrevious(static_cast<PlayListItem*>(static_cast<SafeListViewItem*>(static_cast<SafeListViewItem*>(current())->itemAbove())));
	
	if (emitC && i->playable())
		emit newCurrent();
}

void SplitPlayList::setPrevious(PlayListItem *i)
{
	previousItem=i;
}

void SplitPlayList::remove(PlayListItem *i)
{
	delete i;
}

void SplitPlayList::listItemSelected(QListViewItem *i)
{
	setCurrent(static_cast<PlayListItem*>(static_cast<SafeListViewItem*>(i)));
	emit playCurrent();
}

void SplitPlayList::randomize()
{
	List *lview = view->listView();

	// eeeeevil :)
	QList<void> list;
	QList<QListViewItem> items;
	for ( int i = 0; i < lview->childCount(); i++ ) {
		list.append( (void*) i );
		items.append( lview->itemAtIndex( i ) );
	}

	KRandomSequence seq;
	seq.randomize( &list );

	for ( int i = 0; i < lview->childCount(); i++ ) {
		lview->moveItem( items.take(), 0L,
				 lview->itemAtIndex( (int) list.take() ) );
	}
	
	setCurrent( currentItem );
}


#include "playlist.moc"
