#include "noatunpref.h"

#include <klocale.h>
#include <qlayout.h>
#include <qlabel.h>
#include "cmodule.h"

NoatunPreferences::NoatunPreferences(QWidget *parent)
    : KDialogBase(TreeList, i18n("Noatun Preferences"),
                  Ok|Apply|Close, Ok, parent, 0, false)
{
	resize(640, 480); // KDE is required to support 800x600 min.
}

QFrame *NoatunPreferences::_addModule(const QString &shortTitle,
                                      const QString &longTitle)
{
	QFrame *frame = addPage(shortTitle, longTitle);
	(new QHBoxLayout(frame))->setAutoAdd(true);
	return frame;

}

void NoatunPreferences::_add(CModule *c)
{
	modules.append(c);
	if (isVisible())
		c->reopen();
}

void NoatunPreferences::_remove(CModule *c)
{
	modules.removeRef(c);
	
}

void NoatunPreferences::slotOk()
{
	slotApply();
	hide();
}

void NoatunPreferences::show()
{
	for (CModule *i=modules.first(); i != 0; i=modules.next())
		i->reopen();
	KDialogBase::show();
}

void NoatunPreferences::slotApply()
{
	for (CModule *i=modules.first(); i != 0; i=modules.next())
		i->save();
}

CModule::CModule(QWidget *parent, const char *name) : QFrame (parent, name)
{

}

void CModule::_destroyParentSlot()
{
	napp->preferencesBox()->_remove(this);
	delete parent();
	
}

void CModule::_destroyParent(QObject *p)
{
	if (p)
		connect(p, SIGNAL(destroyed()), SLOT(_destroyParentSlot()));
}

#include "noatunpref.moc"
