#include "noatunplaylist.h"
#include "noatunapp.h"
#include "player.h"
#include "downloader.h"
#include <kcmdlineargs.h>
#include <kfile.h>
#include "pluginloader.h"
#include <kmimetype.h>

PlayListItem::PlayListItem(const KURL &u, bool dl)
	: mLength(-1)
{
		
	setUrl(u, dl);
	mDownloaded= u.isLocalFile();

	QString f(u.fileName());

	//format the filename
	if(napp->hackUpPlaylist())
	{
		int pos=f.findRev('.'); // strip the extension
		f=f.left(pos);

		f=f.replace(QRegExp("_"), " "); //replace underscores with spaces

		// capitalize the first of every word
		f[0]=f[0].upper();

		for (unsigned int pos=1; pos< f.length(); pos++)
		{
			if (f[pos]==' ')
				if (pos+1<f.length())
					f[pos+1]=f[pos+1].upper();
		}
	}
	setTitle(f);
	napp->playlist()->added(this);
}

PlayListItem::~PlayListItem()
{
	napp->downloader()->dequeue(this);
	napp->playlist()->deleted(this);
	
	// don't delete me if we need to access me
	// well, copy me and set a delete after use flag ;)
	if (napp->player()->mCurrent==this && !napp->player()->mDeleteMe)
	{
		napp->player()->mDeleteMe=true;
		// screw a copy constructor;
		PlayListItem *i;
		napp->player()->mCurrent=i=new PlayListItem(*this, false);
		i->mTitle=mTitle;
		i->mUrl=mUrl;
		i->mFile=mFile;
		i->mDownloaded=mDownloaded;
		i->mLength=mLength;
	}
}	

QString PlayListItem::title() const
{
	return mTitle;
}

void PlayListItem::setTitle(const QString &t)
{
	if (mTitle!=t)
	{
		mTitle=t;
		modified();
	}
}
	
KURL PlayListItem::url() const
{
	return mUrl;
}

void PlayListItem::setUrl(const KURL &u, bool dl)
{
	mUrl.setPath(u.path());
	
	if (u.isMalformed()) dl=false;
	else if (u.isLocalFile())
	{
		dl=false;
		mDownloaded=true;
		mFile=u.path();
	}
	if (dl)
	{
		mFile=napp->downloader()->enqueue(this, u);
		mUrl.setPath(mFile);
	}	
	setTitle(u.fileName());
}

void PlayListItem::setLength(int secs)
{
	if (mLength != secs)
	{
		mLength=secs;
		modified();
	}
}

QString PlayListItem::file() const
{
	return mFile;
}

void PlayListItem::doneDownloading()
{
	mDownloaded=true;
	modified();
}

bool PlayListItem::isDownloaded() const
{
	return mDownloaded;
}

bool PlayListItem::playable() const
{
	return QFile(mFile).size()!=0;
}

void PlayListItem::downloaded(int)
{
}

int PlayListItem::fromMille(int mille)
{
	return mille*mLength / 1000;
}

void PlayListItem::modified()
{}

void PlayListItem::timeout()
{
	delete this;
}

QString PlayListItem::lengthString() const
{
	return QString().sprintf("%02d:%02d", length()/60, length()-(length()/60)*60);
}

QCString PlayListItem::mimetype() const
{
	KMimeType::Ptr mimetype = KMimeType::findByURL(mUrl);

	return mimetype->name().latin1();
}

QStrList PlayListItem::extension() const
{
	QStrList extensions;
	KMimeType::Ptr mimetype = KMimeType::findByURL(mUrl);

	const QStringList &patterns = mimetype->patterns();
	QString extension;
	for(QStringList::ConstIterator i = patterns.begin(); i != patterns.end(); ++i)
	{
		int pos = (*i).find(".");
		if( pos != -1 )
			extensions.append((*i).right( (*i).length() - pos - 1 ).latin1());
	}
	return extensions;
}

PlayList::PlayList(QObject *parent, const char *name) : QObject(parent, name)
{
	napp->player()->connect(this, SIGNAL(playCurrent()), SLOT(playCurrent()));
	napp->player()->connect(this, SIGNAL(listHidden()), SIGNAL(playlistHidden()));
	napp->player()->connect(this, SIGNAL(listShown()), SIGNAL(playlistShown()));
	napp->player()->connect(this, SIGNAL(newCurrent()), SLOT(newCurrent()));
}

void PlayList::toggleList()
{
	if (listVisible())
		hideList();
	else
		showList();
}

int PlayList::handleArguments()
{
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	int i;
	bool play= napp->autoPlay();

	for (i=0; i < args->count(); i++)
	{
		KURL u(args->url(i));
		if (!u.isMalformed())
			addFile(u, play);
		play=false;
	}
	args->clear();
	return i;
}

void PlayList::deleted(PlayListItem *item)
{
	emit removed(item);
}

#include "noatunplaylist.moc"

