#ifndef _ENGINE_H
#define _ENGINE_H

#include <qobject.h>
#include <kurl.h>

class Visualization;
class PlayListItem;

namespace Arts
{
	class PlayObject;
	class SimpleSoundServer;

	class StereoVolumeControl;
	class StereoEffectStack_Noatun;
	class Synth_AMAN_PLAY;
	class Equalizer;
}

class AdvancedPlayObject;
class NoatunApp;

/**
 * Handles all playing, connecting to aRts.
 * Does almost everything related to multimedia.
 * Most interfacing should be done with Player
 **/
class Engine : public QObject
{
Q_OBJECT
public:
	Engine(QObject *parent=0);
	~Engine();
	void setInitialized();

public slots:
	/**
	 * Plays the file
	 **/
	bool play(const PlayListItem *file);
	/**
	 * Continues playing
	 **/
	bool play();
	/**
	 * Terminates playing, does not close the file
	 **/
	void pause();
	/**
	 * resets the engine
	 **/
	void stop();
	/**
	 * skips to a timecode
	 * offset is just for more control
	 **/
	void seek(int newTime);

	void setVolume(int percent);

signals:
	void done();

public:
	int state();
	int position();
	int length();
	int volume() const;

private:
	int openMixerFD();
	void closeMixerFD(int);

	bool initArts();

public:
	Arts::SimpleSoundServer *server() const;
	Arts::PlayObject *playObject() const;
	Arts::SimpleSoundServer *simpleSoundServer() const;
	Arts::StereoEffectStack_Noatun *effectStack() const;
	Arts::Equalizer *equalizer() const;
	Arts::StereoEffectStack_Noatun *visualizationStack() const;
	
private:
	class EnginePrivate;
	EnginePrivate *d;
	bool mPlay;
};

#endif
