#ifndef CMODULE_H
#define CMODULE_H

#include <qframe.h>
#include <klistview.h>
#include <noatunpref.h>

class KListView;
class QSplitter;
class QListViewItem;
class NoatunLibraryInfo;

class MimeListItem : public QListViewItem
{
public:
	MimeListItem(KListView *list, const QString &mime, const QString &extension,
	             const QString &author, const QString &url);

public:
	QString mime() const { return mMime; }
	QString extension() const { return mExtension; }
	QString author() const { return mAuthor; }
	QString url() const { return mUrl; }
	
private:
	QString mMime, mExtension, mAuthor, mUrl;
};

class TypeView;
namespace Arts {class TraderOffer;}

class Types : public CModule
{
Q_OBJECT
public:
	Types(QWidget *parent, char *name=0);
	virtual ~Types();
	virtual void save();
	
	static QString commaVector(Arts::TraderOffer *t, const char *field);
	
private:
	KListView *list;
	TypeView *typeview;
};

/*
class MimeView : public QWidget
{
public:
	MimeView(QWidget *parent);

public slots:
//	void setMime(TypeView *view);
	
};
*/
class QCheckBox;
class KURLRequester;

class General : public CModule
{
Q_OBJECT
public:
	General(QWidget *parent, char *name=0);
	virtual void save();

private slots:
	void slotRequesterClicked( KURLRequester * );

private:
	QCheckBox *mAutoPlay, *mLoopList, *mOneInstance, *mRememberPositions, *mClearOnOpen, *mHackUpPlaylist;
	KURLRequester *mDlSaver;

};

class PluginListView : public KListView
{
Q_OBJECT
public:
	PluginListView(QWidget *parent);
protected:
	bool acceptDrag(QDropEvent *event) const;
	QDragObject *dragObject() const;
};

class Plugins : public CModule
{
Q_OBJECT
public:
	Plugins(QWidget *parent, char *name=0);
	virtual void save();
	virtual void reopen();
	
protected slots:
	void removeDropEvent(QDropEvent*, QListViewItem* after);
	void dropEvent(QDropEvent*, QListViewItem* after);

	void moveUp(void);
	void moveDown(void);

	void availableChanged(void);
	void pluginsChanged(void);

private:
	void removePlugin(QListViewItem *i, bool force = false);
	void addPlugin(QListViewItem *i, QListViewItem *after, bool init = false);
	QListViewItem *findInfo(const NoatunLibraryInfo *) const;

private:
	PluginListView *mPlugins;
	PluginListView *mAvailable;
	QButton *mAdd, *mRemove;
	QSplitter *mSplitter;
	QStringList mAdded, mDeleted;
};
#endif
